/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.prey;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import net.dries007.tfc.common.entities.prey.RammingPrey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class RamTargetTFC
extends Behavior<RammingPrey> {
    public static final int TIME_OUT_DURATION = 200;
    public static final float RAM_SPEED_FORCE_FACTOR = 1.65f;
    private final Function<RammingPrey, UniformInt> getTimeBetweenRams;
    private final TargetingConditions ramTargeting;
    private final float speed;
    private final ToDoubleFunction<RammingPrey> getKnockbackForce;
    private Vec3 ramDirection;
    private final Function<RammingPrey, SoundEvent> getImpactSound;

    public RamTargetTFC(Function<RammingPrey, UniformInt> getTimeBetweenRams, TargetingConditions ramTargeting, float speed, ToDoubleFunction<RammingPrey> getKnockbackForce, Function<RammingPrey, SoundEvent> getImpactSound) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_148202_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_148203_, (Object)MemoryStatus.VALUE_PRESENT), 200);
        this.getTimeBetweenRams = getTimeBetweenRams;
        this.ramTargeting = ramTargeting;
        this.speed = speed;
        this.getKnockbackForce = getKnockbackForce;
        this.getImpactSound = getImpactSound;
        this.ramDirection = Vec3.f_82478_;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, RammingPrey rammingPrey) {
        return rammingPrey.m_6274_().m_21874_(MemoryModuleType.f_148203_);
    }

    protected boolean canStillUse(ServerLevel level, RammingPrey rammingPrey, long time) {
        return rammingPrey.m_6274_().m_21874_(MemoryModuleType.f_148203_);
    }

    protected void start(ServerLevel level, RammingPrey rammingPrey, long time) {
        BlockPos blockpos = rammingPrey.m_20183_();
        Brain<RammingPrey> brain = rammingPrey.m_6274_();
        Vec3 ramTargetVector = (Vec3)brain.m_21952_(MemoryModuleType.f_148203_).get();
        this.ramDirection = new Vec3((double)blockpos.m_123341_() - ramTargetVector.m_7096_(), 0.0, (double)blockpos.m_123343_() - ramTargetVector.m_7094_()).m_82541_();
        brain.m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(ramTargetVector, this.speed, 0));
    }

    protected void tick(ServerLevel level, RammingPrey rammingPrey, long time) {
        Brain<RammingPrey> brain = rammingPrey.m_6274_();
        List list = level.m_45971_(LivingEntity.class, this.ramTargeting, (LivingEntity)rammingPrey, rammingPrey.m_20191_().m_82400_(rammingPrey.getRammingReach()));
        if (!list.isEmpty()) {
            LivingEntity livingentity = (LivingEntity)list.get(0);
            livingentity.m_6469_(level.m_269111_().m_269364_((LivingEntity)rammingPrey), (float)rammingPrey.m_21133_(Attributes.f_22281_) * rammingPrey.getAttackDamageMultiplier());
            int i = rammingPrey.m_21023_(MobEffects.f_19596_) ? rammingPrey.m_21124_(MobEffects.f_19596_).m_19564_() + 1 : 0;
            int j = rammingPrey.m_21023_(MobEffects.f_19597_) ? rammingPrey.m_21124_(MobEffects.f_19597_).m_19564_() + 1 : 0;
            float f = 0.25f * (float)(i - j);
            float f1 = Mth.m_14036_((float)(rammingPrey.m_6113_() * 1.65f), (float)0.2f, (float)3.0f) + f;
            float f2 = livingentity.m_21275_(level.m_269111_().m_269333_((LivingEntity)rammingPrey)) ? 0.5f : 1.0f;
            float f3 = rammingPrey.getAttackDamageMultiplier() * 0.6f;
            livingentity.m_147240_((double)(f1 * f2 * f3) * this.getKnockbackForce.applyAsDouble(rammingPrey), this.ramDirection.m_7096_(), this.ramDirection.m_7094_());
            this.finishRam(level, rammingPrey);
            level.m_6269_((Player)null, (Entity)rammingPrey, this.getImpactSound.apply(rammingPrey), SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else {
            boolean flag1;
            Optional optionalWalkTarget = brain.m_21952_(MemoryModuleType.f_26370_);
            Optional optionalRamTarget = brain.m_21952_(MemoryModuleType.f_148203_);
            boolean bl = flag1 = optionalWalkTarget.isEmpty() || optionalRamTarget.isEmpty() || ((WalkTarget)optionalWalkTarget.get()).m_26420_().m_7024_().m_82509_((Position)optionalRamTarget.get(), 0.25);
            if (flag1) {
                this.finishRam(level, rammingPrey);
            }
        }
    }

    protected void finishRam(ServerLevel serverLevel, RammingPrey rammingPrey) {
        serverLevel.m_7605_((Entity)rammingPrey, (byte)59);
        rammingPrey.m_6274_().m_21879_(MemoryModuleType.f_148202_, (Object)this.getTimeBetweenRams.apply(rammingPrey).m_214085_(serverLevel.f_46441_));
        rammingPrey.m_6274_().m_21936_(MemoryModuleType.f_148203_);
    }
}

