/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.predator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.ai.FastGateBehavior;
import net.dries007.tfc.common.entities.ai.SetLookTarget;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.pet.MoveToTargetSinkIfNotSleeping;
import net.dries007.tfc.common.entities.ai.predator.AggressiveSwim;
import net.dries007.tfc.common.entities.ai.predator.PredatorBehaviors;
import net.dries007.tfc.common.entities.predator.Predator;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StrollAroundPoi;
import net.minecraft.world.entity.ai.behavior.StrollToPoi;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;

public class PredatorAi {
    public static final ImmutableList<? extends SensorType<? extends Sensor<? super Predator>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26814_);
    public static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26375_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148206_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26373_, (Object)MemoryModuleType.f_26357_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26359_, MemoryModuleType.f_26340_, (MemoryModuleType)TFCBrain.WAKEUP_TICKS.get()});
    public static final int MAX_WANDER_DISTANCE = 10000;
    public static final int MAX_ATTACK_DISTANCE = 6400;

    public static Brain<?> makeBrain(Brain<? extends Predator> brain, Predator predator) {
        PredatorAi.initCoreActivity(brain);
        PredatorAi.initHuntActivity(brain);
        PredatorAi.initRetreatActivity(brain);
        PredatorAi.initRestActivity(brain);
        PredatorAi.initFightActivity(brain);
        brain.m_21912_(predator.diurnal ? (Schedule)TFCBrain.DIURNAL.get() : (Schedule)TFCBrain.NOCTURNAL.get());
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_((Activity)TFCBrain.HUNT.get());
        brain.m_21889_((Activity)TFCBrain.HUNT.get());
        brain.m_21862_(predator.m_9236_().m_46468_(), predator.m_9236_().m_46467_());
        return brain;
    }

    public static void updateActivity(Predator predator) {
        Brain<Predator> brain = predator.m_6274_();
        brain.m_21926_((List)ImmutableList.of((Object)Activity.f_37991_, (Object)Activity.f_37988_));
        if (brain.m_21968_().isPresent()) {
            Activity current = (Activity)brain.m_21968_().get();
            if (current == Activity.f_37988_ && !brain.m_21874_(MemoryModuleType.f_26372_)) {
                brain.m_21862_(predator.m_9236_().m_46468_(), predator.m_9236_().m_46467_());
            } else if (current == Activity.f_37991_ && !brain.m_21874_(MemoryModuleType.f_26357_)) {
                brain.m_21862_(predator.m_9236_().m_46468_(), predator.m_9236_().m_46467_());
            }
        }
        predator.m_21561_(brain.m_21874_(MemoryModuleType.f_26372_));
    }

    public static void initCoreActivity(Brain<? extends Predator> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)((Object)new AggressiveSwim(0.8f)), (Object)new LookAtTargetSink(45, 90), (Object)((Object)new MoveToTargetSinkIfNotSleeping()), (Object)new CountDownCooldownTicks((MemoryModuleType)TFCBrain.WAKEUP_TICKS.get())));
    }

    public static void initHuntActivity(Brain<? extends Predator> brain) {
        brain.m_21891_((Activity)TFCBrain.HUNT.get(), 10, ImmutableList.of(PredatorBehaviors.becomePassiveIf(p -> p.m_21223_() < 5.0f, 200), (Object)StartAttacking.m_257710_(PredatorAi::getAttackTarget), SetLookTarget.create(8.0f, UniformInt.m_146622_((int)30, (int)60)), (Object)BabyFollowAdult.m_257685_((UniformInt)UniformInt.m_146622_((int)5, (int)16), (float)1.25f), PredatorAi.createIdleMovementBehaviors(), PredatorBehaviors.tickScheduleAndWake()));
    }

    public static void initRetreatActivity(Brain<? extends Predator> brain) {
        brain.m_21895_(Activity.f_37991_, 10, ImmutableList.of((Object)BehaviorBuilder.m_257845_(PredatorAi::hasNearbyAttacker, (OneShot)SetWalkTargetAwayFrom.m_257370_((MemoryModuleType)MemoryModuleType.f_26382_, (float)1.2f, (int)16, (boolean)true)), (Object)StrollToPoi.m_258086_((MemoryModuleType)MemoryModuleType.f_26359_, (float)1.2f, (int)5, (int)10000), PredatorAi.createIdleMovementBehaviors()), MemoryModuleType.f_26357_);
    }

    public static void initRestActivity(Brain<? extends Predator> brain) {
        brain.m_21891_(Activity.f_37982_, 10, ImmutableList.of((Object)StartAttacking.m_257710_(PredatorAi::getDisturbedAttackTarget), PredatorBehaviors.findNewHome(), (Object)StrollToPoi.m_258086_((MemoryModuleType)MemoryModuleType.f_26359_, (float)1.2f, (int)5, (int)10000), PredatorBehaviors.startSleeping(), PredatorBehaviors.tickScheduleAndWake(), PredatorBehaviors.wakeFromDisturbance()));
    }

    public static void initFightActivity(Brain<? extends Predator> brain) {
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of(PredatorBehaviors.becomePassiveIf(p -> p.m_21223_() < 5.0f, 200), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)1.15f), (Object)MeleeAttack.m_257733_((int)40), PredatorBehaviors.stopAttackingIfTooFarFromHome()), MemoryModuleType.f_26372_);
    }

    public static FastGateBehavior<Predator> createIdleMovementBehaviors() {
        return FastGateBehavior.runOne(ImmutableList.of((Object)RandomStroll.m_257965_((float)0.4f), (Object)SetWalkTargetFromLookTarget.m_257764_((float)0.4f, (int)3), (Object)new DoNothing(30, 60), (Object)StrollToPoi.m_258086_((MemoryModuleType)MemoryModuleType.f_26359_, (float)0.6f, (int)2, (int)5), (Object)StrollAroundPoi.m_257894_((MemoryModuleType)MemoryModuleType.f_26359_, (float)0.6f, (int)10000)));
    }

    public static Optional<? extends LivingEntity> getDisturbedAttackTarget(Predator predator) {
        return predator.m_6274_().m_21952_((MemoryModuleType)TFCBrain.WAKEUP_TICKS.get()).isPresent() ? PredatorAi.getAttackTarget(predator) : Optional.empty();
    }

    public static Optional<? extends LivingEntity> getAttackTarget(Predator predator) {
        if (PredatorAi.isPacified(predator)) {
            return Optional.empty();
        }
        Brain<Predator> brain = predator.m_6274_();
        if (brain.m_21874_(MemoryModuleType.f_148206_)) {
            return brain.m_21952_(MemoryModuleType.f_148206_);
        }
        if (brain.m_21874_(MemoryModuleType.f_148205_)) {
            NearestVisibleLivingEntities nearestEntities = (NearestVisibleLivingEntities)brain.m_21952_(MemoryModuleType.f_148205_).get();
            return nearestEntities.m_186116_(e -> Helpers.isEntity((Entity)e, TFCTags.Entities.HUNTED_BY_LAND_PREDATORS) && !e.m_20069_());
        }
        return Optional.empty();
    }

    private static boolean isPacified(Predator predator) {
        return predator.m_6162_() || predator.m_6274_().m_21874_(MemoryModuleType.f_26357_) || predator.m_6274_().m_21874_(MemoryModuleType.f_26340_);
    }

    public static double getDistanceFromHomeSqr(LivingEntity predator) {
        return predator.m_20183_().m_123331_((Vec3i)PredatorAi.getHomePos(predator));
    }

    public static BlockPos getHomePos(LivingEntity predator) {
        Optional memory = predator.m_6274_().m_21952_(MemoryModuleType.f_26359_);
        if (memory.isPresent()) {
            return ((GlobalPos)memory.get()).m_122646_();
        }
        predator.m_6274_().m_21879_(MemoryModuleType.f_26359_, (Object)GlobalPos.m_122643_((ResourceKey)predator.m_9236_().m_46472_(), (BlockPos)predator.m_20183_()));
        return predator.m_20183_();
    }

    public static boolean hasNearbyAttacker(LivingEntity predator) {
        return predator.m_6274_().m_21952_(MemoryModuleType.f_26382_).map(entity -> entity.m_20280_((Entity)predator) < 256.0).orElse(false);
    }
}

