/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.predator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.dries007.tfc.common.entities.ai.SetLookTarget;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.predator.AggressiveSwim;
import net.dries007.tfc.common.entities.ai.predator.PackPredator;
import net.dries007.tfc.common.entities.ai.predator.PredatorAi;
import net.dries007.tfc.common.entities.ai.predator.PredatorBehaviors;
import net.dries007.tfc.common.entities.predator.Predator;
import net.minecraft.Util;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import org.jetbrains.annotations.Nullable;

public class PackPredatorAi {
    public static final ImmutableList<SensorType<? extends Sensor<? super PackPredator>>> SENSOR_TYPES = (ImmutableList)Util.m_137537_(() -> {
        ArrayList list = Lists.newArrayList(PredatorAi.SENSOR_TYPES);
        list.add((SensorType)TFCBrain.PACK_LEADER_SENSOR.get());
        list.add((SensorType)TFCBrain.TEMPTATION_SENSOR.get());
        return ImmutableList.copyOf((Collection)list);
    });
    public static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = (ImmutableList)Util.m_137537_(() -> {
        ArrayList list = Lists.newArrayList(PredatorAi.MEMORY_TYPES);
        list.add((MemoryModuleType)TFCBrain.ALPHA.get());
        list.add(MemoryModuleType.f_148196_);
        list.add(MemoryModuleType.f_217768_);
        list.add(MemoryModuleType.f_148197_);
        list.add(MemoryModuleType.f_148198_);
        return ImmutableList.copyOf((Collection)list);
    });

    public static Brain<?> makeBrain(Brain<? extends Predator> brain, Predator predator) {
        PackPredatorAi.initCoreActivity(brain);
        PackPredatorAi.initHuntActivity(brain);
        PredatorAi.initRetreatActivity(brain);
        PredatorAi.initRestActivity(brain);
        PredatorAi.initFightActivity(brain);
        brain.m_21912_(predator.diurnal ? (Schedule)TFCBrain.DIURNAL.get() : (Schedule)TFCBrain.NOCTURNAL.get());
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_((Activity)TFCBrain.HUNT.get());
        brain.m_21889_((Activity)TFCBrain.HUNT.get());
        brain.m_21862_(predator.m_9236_().m_46468_(), predator.m_9236_().m_46467_());
        return brain;
    }

    public static void initCoreActivity(Brain<? extends Predator> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)((Object)new AggressiveSwim(0.8f)), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_)));
    }

    public static void initHuntActivity(Brain<? extends Predator> brain) {
        brain.m_21891_((Activity)TFCBrain.HUNT.get(), 10, ImmutableList.of(PredatorBehaviors.becomePassiveIf(p -> p.m_21223_() < 5.0f || PackPredatorAi.isAlphaPassive(p), 200), PredatorBehaviors.becomePassiveIf(p -> p.m_6274_().m_21874_(MemoryModuleType.f_148196_), 400), (Object)StartAttacking.m_257710_(PackPredatorAi::getAttackTarget), SetLookTarget.create(8.0f, UniformInt.m_146622_((int)30, (int)60)), PredatorBehaviors.findNewHome(), PredatorBehaviors.listenToAlpha(), (Object)new FollowTemptation(e -> Float.valueOf(e.m_6162_() ? 1.5f : 1.2f)), (Object)BabyFollowAdult.m_257685_((UniformInt)UniformInt.m_146622_((int)5, (int)16), (float)1.25f), PredatorAi.createIdleMovementBehaviors(), PredatorBehaviors.tickScheduleAndWake()));
    }

    public static boolean isAlphaPassive(Predator predator) {
        return PackPredatorAi.getAlpha(predator).m_6274_().m_21952_(MemoryModuleType.f_26357_).orElse(false);
    }

    public static Optional<? extends LivingEntity> getAttackTarget(Predator predator) {
        return PackPredatorAi.isAlpha(predator) ? PredatorAi.getAttackTarget(predator) : PackPredatorAi.getMemoryFromAlpha(predator, MemoryModuleType.f_26372_);
    }

    public static <T> Optional<T> getMemoryFromAlpha(Predator predator, MemoryModuleType<T> memory) {
        return PackPredatorAi.getAlpha(predator).m_6274_().m_21952_(memory);
    }

    public static boolean isNotAlpha(Predator predator) {
        return !PackPredatorAi.getAlpha(predator).equals(predator);
    }

    public static boolean isAlpha(Predator predator) {
        return PackPredatorAi.getAlpha(predator).equals(predator);
    }

    public static void alertOthers(PackPredator predator, @Nullable LivingEntity target) {
        predator.m_6274_().m_21952_(MemoryModuleType.f_148204_).ifPresent(list -> list.forEach(entity -> {
            if (entity instanceof PackPredator) {
                PackPredator otherPredator = (PackPredator)entity;
                if (target != null) {
                    otherPredator.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)target);
                }
                otherPredator.m_6274_().m_21936_(MemoryModuleType.f_26340_);
                otherPredator.m_6274_().m_21936_(MemoryModuleType.f_26357_);
                otherPredator.m_6274_().m_21889_(Activity.f_37988_);
                otherPredator.setSleeping(false);
            }
        }));
    }

    public static PackPredator getAlpha(Predator predator) {
        return predator.m_6274_().m_21952_((MemoryModuleType)TFCBrain.ALPHA.get()).orElse((PackPredator)predator);
    }
}

