/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.pet;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jetbrains.annotations.Nullable;

public abstract class MoveOntoBlockBehavior<T extends PathfinderMob>
extends Behavior<T> {
    @Nullable
    protected BlockPos targetPos;
    private int remainingTimeToReach;
    private final MemoryModuleType<?> memory;
    private final boolean erase;

    public MoveOntoBlockBehavior(MemoryModuleType<?> memory, boolean erase) {
        super((Map)ImmutableMap.of(memory, (Object)MemoryStatus.VALUE_PRESENT));
        this.memory = memory;
        this.erase = erase;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, T animal) {
        return !animal.m_20159_() && !animal.m_5803_();
    }

    protected void start(ServerLevel level, T mob, long time) {
        this.getNearestTarget(mob).ifPresent(pos -> {
            this.targetPos = pos;
            this.remainingTimeToReach = 100;
            this.startWalkingTowards(mob, (BlockPos)pos);
        });
    }

    protected void stop(ServerLevel level, T mob, long time) {
        this.targetPos = null;
        this.remainingTimeToReach = 0;
    }

    protected boolean canStillUse(ServerLevel level, T animal, long time) {
        return this.targetPos != null && this.checkExtraStartConditions(level, animal) && this.isTargetAt(level, this.targetPos) && !this.tiredOfWalking(level, animal);
    }

    protected boolean m_7773_(long time) {
        return false;
    }

    protected void tick(ServerLevel level, T mob, long time) {
        if (!this.onTarget(level, mob)) {
            --this.remainingTimeToReach;
        } else {
            this.afterReached(mob);
            mob.m_6274_().m_21936_(MemoryModuleType.f_26370_);
            this.targetPos = null;
            if (this.erase) {
                mob.m_6274_().m_21936_(this.memory);
            }
        }
    }

    protected abstract void afterReached(T var1);

    protected abstract Optional<BlockPos> getNearestTarget(T var1);

    protected abstract boolean isTargetAt(ServerLevel var1, BlockPos var2);

    protected boolean onTarget(ServerLevel level, T mob) {
        return this.isTargetAt(level, mob.m_20183_());
    }

    private void startWalkingTowards(T mob, BlockPos pos) {
        BehaviorUtils.m_22617_(mob, (BlockPos)pos, (float)1.0f, (int)1);
    }

    private boolean tiredOfWalking(ServerLevel level, T mob) {
        if (!this.onTarget(level, mob) && this.remainingTimeToReach <= 0) {
            if (this.erase) {
                mob.m_6274_().m_21936_(this.memory);
            }
            return true;
        }
        return false;
    }
}

