/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.livestock;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.dries007.tfc.common.entities.BrainBreeder;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.LevelReader;

public class BreedBehavior<T extends Animal>
extends Behavior<T> {
    private final float speedModifier;
    private long spawnChildAtTime;
    private long nextAttemptTime = -1L;

    public BreedBehavior(float speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26375_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), 110);
        this.speedModifier = speed;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, T animal) {
        if (level.m_46467_() > this.nextAttemptTime) {
            this.nextAttemptTime = level.m_46467_() + 200L;
            return ((BrainBreeder)animal).isMale() && this.findValidBreedPartner(animal).isPresent();
        }
        return false;
    }

    protected void start(ServerLevel level, T animal, long time) {
        AgeableMob target = this.findValidBreedPartner(animal).get();
        animal.m_6274_().m_21879_(MemoryModuleType.f_26375_, (Object)target);
        target.m_6274_().m_21879_(MemoryModuleType.f_26375_, animal);
        BehaviorUtils.m_22602_(animal, (LivingEntity)target, (float)this.speedModifier);
        this.spawnChildAtTime = time + 60L + (long)animal.m_217043_().m_188503_(50);
    }

    protected boolean canStillUse(ServerLevel level, T animal, long time) {
        Animal targetAnimal;
        if (!this.hasValidBreedPartner(animal)) {
            return false;
        }
        AgeableMob target = (AgeableMob)animal.m_6274_().m_21952_(MemoryModuleType.f_26375_).get();
        return target.m_6084_() && target instanceof Animal && animal.m_7848_(targetAnimal = (Animal)target) && BehaviorUtils.m_22636_((Brain)animal.m_6274_(), (LivingEntity)target) && time <= this.spawnChildAtTime;
    }

    protected void tick(ServerLevel level, T animal, long time) {
        AgeableMob target = (AgeableMob)animal.m_6274_().m_21952_(MemoryModuleType.f_26375_).get();
        BehaviorUtils.m_22602_(animal, (LivingEntity)target, (float)this.speedModifier);
        if (animal.m_19950_((Entity)target, 3.0) && time >= this.spawnChildAtTime) {
            target.m_142606_(level, animal);
            animal.m_6274_().m_21936_(MemoryModuleType.f_26375_);
            target.m_6274_().m_21936_(MemoryModuleType.f_26375_);
        }
    }

    protected void stop(ServerLevel level, T animal, long speed) {
        ((BrainBreeder)animal).setMated(Calendars.get((LevelReader)level).getTicks());
        animal.m_6274_().m_21936_(MemoryModuleType.f_26375_);
        animal.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        animal.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        this.spawnChildAtTime = 0L;
    }

    private boolean hasValidBreedPartner(T animal) {
        Brain brain = animal.m_6274_();
        if (brain.m_21874_(MemoryModuleType.f_26375_)) {
            BrainBreeder brainBreeder;
            AgeableMob target = (AgeableMob)brain.m_21952_(MemoryModuleType.f_26375_).get();
            return animal.m_6095_() == target.m_6095_() && target instanceof BrainBreeder && !(brainBreeder = (BrainBreeder)target).isMale();
        }
        return false;
    }

    private Optional<AgeableMob> findValidBreedPartner(T animal) {
        return ((NearestVisibleLivingEntities)animal.m_6274_().m_21952_(MemoryModuleType.f_148205_).get()).m_186116_(target -> {
            Animal targetAnimal;
            return target.m_6095_() == animal.m_6095_() && target instanceof Animal && animal.m_7848_(targetAnimal = (Animal)target);
        }).map(t -> (AgeableMob)t);
    }
}

