/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import net.dries007.tfc.common.TFCDamageSources;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.events.AnimalProductEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemHandlerHelper;

public interface Pluckable {
    public static final int PLUCKING_COOLDOWN = 1000;

    public long getLastPluckedTick();

    public void setLastPluckedTick(long var1);

    /*
     * Enabled aggressive block sorting
     */
    default public boolean pluck(Player player, InteractionHand hand, LivingEntity entity) {
        Level level = entity.m_9236_();
        if (level.f_46443_) return false;
        if (hand == InteractionHand.OFF_HAND) {
            return false;
        }
        if (!player.m_21120_(hand).m_41619_()) return false;
        if (!player.m_6144_()) return false;
        if (!(entity.m_21223_() / entity.m_21233_() > 0.15001f)) return false;
        if (Calendars.SERVER.getTicks() < this.getLastPluckedTick() + 1000L) {
            player.m_5661_((Component)Component.m_237110_((String)"tfc.tooltip.animal.cannot_pluck", (Object[])new Object[]{ICalendar.getTimeDelta(1000L - (Calendars.SERVER.getTicks() - this.getLastPluckedTick()), Calendars.SERVER.getCalendarDaysInMonth())}), true);
            return false;
        }
        if (entity.m_21223_() / entity.m_21233_() <= 0.15f) {
            player.m_5661_((Component)Component.m_237115_((String)"tfc.tooltip.animal.cannot_pluck_old_or_sick"), true);
            return false;
        }
        ItemStack feather = new ItemStack((ItemLike)Items.f_42402_, Mth.m_216271_((RandomSource)entity.m_217043_(), (int)1, (int)3));
        if (!(entity instanceof TFCAnimalProperties)) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)feather);
            TFCDamageSources.pluck((Entity)entity, entity.m_21233_() * 0.15f, null);
            this.setLastPluckedTick(Calendars.SERVER.getTicks());
            return true;
        }
        TFCAnimalProperties properties = (TFCAnimalProperties)entity;
        if (properties.getAgeType() == TFCAnimalProperties.Age.ADULT && properties.getUses() < properties.getUsesToElderly()) {
            AnimalProductEvent event = new AnimalProductEvent(level, entity.m_20183_(), player, properties, feather, ItemStack.f_41583_, 1);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                TFCDamageSources.pluck((Entity)entity, entity.m_21233_() * 0.15f, null);
                properties.addUses(event.getUses());
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)event.getProduct());
            }
            this.setLastPluckedTick(Calendars.SERVER.getTicks());
            return true;
        }
        player.m_5661_((Component)Component.m_237115_((String)"tfc.tooltip.animal.cannot_pluck_old_or_sick"), true);
        return false;
    }
}

