/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.Fauna;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.entities.ai.predator.PackPredator;
import net.dries007.tfc.common.entities.ai.prey.TFCOcelot;
import net.dries007.tfc.common.entities.aquatic.AquaticCritter;
import net.dries007.tfc.common.entities.aquatic.AquaticMob;
import net.dries007.tfc.common.entities.aquatic.Fish;
import net.dries007.tfc.common.entities.aquatic.FreshwaterFish;
import net.dries007.tfc.common.entities.aquatic.Jellyfish;
import net.dries007.tfc.common.entities.aquatic.Manatee;
import net.dries007.tfc.common.entities.aquatic.Octopoteuthis;
import net.dries007.tfc.common.entities.aquatic.Penguin;
import net.dries007.tfc.common.entities.aquatic.TFCCod;
import net.dries007.tfc.common.entities.aquatic.TFCDolphin;
import net.dries007.tfc.common.entities.aquatic.TFCPufferfish;
import net.dries007.tfc.common.entities.aquatic.TFCSquid;
import net.dries007.tfc.common.entities.aquatic.TFCTropicalFish;
import net.dries007.tfc.common.entities.aquatic.TFCTurtle;
import net.dries007.tfc.common.entities.livestock.DairyAnimal;
import net.dries007.tfc.common.entities.livestock.Mammal;
import net.dries007.tfc.common.entities.livestock.OviparousAnimal;
import net.dries007.tfc.common.entities.livestock.WoolyAnimal;
import net.dries007.tfc.common.entities.livestock.horse.TFCDonkey;
import net.dries007.tfc.common.entities.livestock.horse.TFCHorse;
import net.dries007.tfc.common.entities.livestock.horse.TFCMule;
import net.dries007.tfc.common.entities.predator.AmphibiousPredator;
import net.dries007.tfc.common.entities.predator.FelinePredator;
import net.dries007.tfc.common.entities.predator.Predator;
import net.dries007.tfc.common.entities.prey.Prey;
import net.dries007.tfc.common.entities.prey.RammingPrey;
import net.dries007.tfc.common.entities.prey.TFCFox;
import net.dries007.tfc.common.entities.prey.TFCFrog;
import net.dries007.tfc.common.entities.prey.TFCPanda;
import net.dries007.tfc.common.entities.prey.TFCRabbit;
import net.dries007.tfc.common.entities.prey.WingedPrey;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.RegisteredDataManager;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.registries.RegistryObject;

public class Faunas {
    public static final FaunaType<TFCCod> COD = Faunas.registerFish(TFCEntities.COD);
    public static final FaunaType<Jellyfish> JELLYFISH = Faunas.registerFish(TFCEntities.JELLYFISH);
    public static final FaunaType<TFCTropicalFish> TROPICAL_FISH = Faunas.registerFish(TFCEntities.TROPICAL_FISH);
    public static final FaunaType<TFCPufferfish> PUFFERFISH = Faunas.registerFish(TFCEntities.PUFFERFISH);
    public static final Map<Fish, FaunaType<FreshwaterFish>> FRESHWATER_FISH = Helpers.mapOfKeys(Fish.class, fish -> Faunas.registerFish(TFCEntities.FRESHWATER_FISH.get(fish)));
    public static final FaunaType<AquaticCritter> LOBSTER = Faunas.registerFish(TFCEntities.LOBSTER);
    public static final FaunaType<AquaticCritter> CRAYFISH = Faunas.registerFish(TFCEntities.CRAYFISH);
    public static final FaunaType<AquaticCritter> ISOPOD = Faunas.registerFish(TFCEntities.ISOPOD);
    public static final FaunaType<AquaticCritter> HORSESHOE_CRAB = Faunas.registerFish(TFCEntities.HORSESHOE_CRAB);
    public static final FaunaType<TFCDolphin> DOLPHIN = Faunas.registerFish(TFCEntities.DOLPHIN);
    public static final FaunaType<TFCDolphin> ORCA = Faunas.registerFish(TFCEntities.ORCA);
    public static final FaunaType<Manatee> MANATEE = Faunas.registerFish(TFCEntities.MANATEE);
    public static final FaunaType<TFCTurtle> TURTLE = Faunas.registerAnimal(TFCEntities.TURTLE);
    public static final FaunaType<Penguin> PENGUIN = Faunas.registerAnimal(TFCEntities.PENGUIN);
    public static final FaunaType<TFCFrog> FROG = Faunas.registerAnimal(TFCEntities.FROG);
    public static final FaunaType<Predator> POLAR_BEAR = Faunas.registerAnimal(TFCEntities.POLAR_BEAR);
    public static final FaunaType<Predator> GRIZZLY_BEAR = Faunas.registerAnimal(TFCEntities.GRIZZLY_BEAR);
    public static final FaunaType<Predator> BLACK_BEAR = Faunas.registerAnimal(TFCEntities.BLACK_BEAR);
    public static final FaunaType<FelinePredator> COUGAR = Faunas.registerAnimal(TFCEntities.COUGAR);
    public static final FaunaType<FelinePredator> PANTHER = Faunas.registerAnimal(TFCEntities.PANTHER);
    public static final FaunaType<FelinePredator> LION = Faunas.registerAnimal(TFCEntities.LION);
    public static final FaunaType<FelinePredator> SABERTOOTH = Faunas.registerAnimal(TFCEntities.SABERTOOTH);
    public static final FaunaType<FelinePredator> TIGER = Faunas.registerAnimal(TFCEntities.TIGER);
    public static final FaunaType<AmphibiousPredator> CROCODILE = Faunas.registerAmphibiousPredator(TFCEntities.CROCODILE);
    public static final FaunaType<PackPredator> WOLF = Faunas.registerAnimal(TFCEntities.WOLF);
    public static final FaunaType<PackPredator> HYENA = Faunas.registerAnimal(TFCEntities.HYENA);
    public static final FaunaType<PackPredator> DIREWOLF = Faunas.registerAnimal(TFCEntities.DIREWOLF);
    public static final FaunaType<TFCSquid> SQUID = Faunas.registerFish(TFCEntities.SQUID);
    public static final FaunaType<Octopoteuthis> OCTOPOTEUTHIS = Faunas.registerFish(TFCEntities.OCTOPOTEUTHIS);
    public static final FaunaType<Mammal> PIG = Faunas.registerAnimal(TFCEntities.PIG);
    public static final FaunaType<DairyAnimal> COW = Faunas.registerAnimal(TFCEntities.COW);
    public static final FaunaType<DairyAnimal> GOAT = Faunas.registerAnimal(TFCEntities.GOAT);
    public static final FaunaType<DairyAnimal> YAK = Faunas.registerAnimal(TFCEntities.YAK);
    public static final FaunaType<WoolyAnimal> ALPACA = Faunas.registerAnimal(TFCEntities.ALPACA);
    public static final FaunaType<WoolyAnimal> SHEEP = Faunas.registerAnimal(TFCEntities.SHEEP);
    public static final FaunaType<WoolyAnimal> MUSK_OX = Faunas.registerAnimal(TFCEntities.MUSK_OX);
    public static final FaunaType<OviparousAnimal> CHICKEN = Faunas.registerAnimal(TFCEntities.CHICKEN);
    public static final FaunaType<OviparousAnimal> DUCK = Faunas.registerAnimal(TFCEntities.DUCK);
    public static final FaunaType<OviparousAnimal> QUAIL = Faunas.registerAnimal(TFCEntities.QUAIL);
    public static final FaunaType<TFCRabbit> RABBIT = Faunas.registerAnimal(TFCEntities.RABBIT);
    public static final FaunaType<TFCFox> FOX = Faunas.registerAnimal(TFCEntities.FOX);
    public static final FaunaType<TFCPanda> PANDA = Faunas.registerAnimal(TFCEntities.PANDA);
    public static final FaunaType<TFCOcelot> OCELOT = Faunas.registerAnimal(TFCEntities.OCELOT);
    public static final FaunaType<RammingPrey> BOAR = Faunas.registerAnimal(TFCEntities.BOAR);
    public static final FaunaType<RammingPrey> WILDEBEEST = Faunas.registerAnimal(TFCEntities.WILDEBEEST);
    public static final FaunaType<Prey> BONGO = Faunas.registerAnimal(TFCEntities.BONGO);
    public static final FaunaType<Prey> CARIBOU = Faunas.registerAnimal(TFCEntities.CARIBOU);
    public static final FaunaType<Prey> DEER = Faunas.registerAnimal(TFCEntities.DEER);
    public static final FaunaType<Prey> GAZELLE = Faunas.registerAnimal(TFCEntities.GAZELLE);
    public static final FaunaType<RammingPrey> MOOSE = Faunas.registerAnimal(TFCEntities.MOOSE);
    public static final FaunaType<WingedPrey> GROUSE = Faunas.registerAnimal(TFCEntities.GROUSE);
    public static final FaunaType<WingedPrey> PHEASANT = Faunas.registerAnimal(TFCEntities.PHEASANT);
    public static final FaunaType<WingedPrey> TURKEY = Faunas.registerAnimal(TFCEntities.TURKEY);
    public static final FaunaType<WingedPrey> PEAFOWL = Faunas.registerAnimal(TFCEntities.PEAFOWL);
    public static final FaunaType<TFCDonkey> DONKEY = Faunas.registerAnimal(TFCEntities.DONKEY);
    public static final FaunaType<TFCMule> MULE = Faunas.registerAnimal(TFCEntities.MULE);
    public static final FaunaType<TFCHorse> HORSE = Faunas.registerAnimal(TFCEntities.HORSE);

    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        FRESHWATER_FISH.values().forEach(fish -> Faunas.registerSpawnPlacement(event, fish));
        Faunas.registerSpawnPlacement(event, COD);
        Faunas.registerSpawnPlacement(event, JELLYFISH);
        Faunas.registerSpawnPlacement(event, TROPICAL_FISH);
        Faunas.registerSpawnPlacement(event, PUFFERFISH);
        Faunas.registerSpawnPlacement(event, LOBSTER);
        Faunas.registerSpawnPlacement(event, CRAYFISH);
        Faunas.registerSpawnPlacement(event, ISOPOD);
        Faunas.registerSpawnPlacement(event, HORSESHOE_CRAB);
        Faunas.registerSpawnPlacement(event, DOLPHIN);
        Faunas.registerSpawnPlacement(event, ORCA);
        Faunas.registerSpawnPlacement(event, MANATEE);
        Faunas.registerSpawnPlacement(event, TURTLE);
        Faunas.registerSpawnPlacement(event, PENGUIN);
        Faunas.registerSpawnPlacement(event, FROG);
        Faunas.registerSpawnPlacement(event, POLAR_BEAR);
        Faunas.registerSpawnPlacement(event, GRIZZLY_BEAR);
        Faunas.registerSpawnPlacement(event, BLACK_BEAR);
        Faunas.registerSpawnPlacement(event, COUGAR);
        Faunas.registerSpawnPlacement(event, PANTHER);
        Faunas.registerSpawnPlacement(event, LION);
        Faunas.registerSpawnPlacement(event, SABERTOOTH);
        Faunas.registerSpawnPlacement(event, TIGER);
        Faunas.registerSpawnPlacement(event, CROCODILE);
        Faunas.registerSpawnPlacement(event, SQUID);
        Faunas.registerSpawnPlacement(event, OCTOPOTEUTHIS);
        Faunas.registerSpawnPlacement(event, PIG);
        Faunas.registerSpawnPlacement(event, COW);
        Faunas.registerSpawnPlacement(event, GOAT);
        Faunas.registerSpawnPlacement(event, YAK);
        Faunas.registerSpawnPlacement(event, ALPACA);
        Faunas.registerSpawnPlacement(event, SHEEP);
        Faunas.registerSpawnPlacement(event, MUSK_OX);
        Faunas.registerSpawnPlacement(event, CHICKEN);
        Faunas.registerSpawnPlacement(event, DUCK);
        Faunas.registerSpawnPlacement(event, QUAIL);
        Faunas.registerSpawnPlacement(event, RABBIT);
        Faunas.registerSpawnPlacement(event, FOX);
        Faunas.registerSpawnPlacement(event, PANDA);
        Faunas.registerSpawnPlacement(event, OCELOT);
        Faunas.registerSpawnPlacement(event, BOAR);
        Faunas.registerSpawnPlacement(event, WILDEBEEST);
        Faunas.registerSpawnPlacement(event, MOOSE);
        Faunas.registerSpawnPlacement(event, BONGO);
        Faunas.registerSpawnPlacement(event, CARIBOU);
        Faunas.registerSpawnPlacement(event, DEER);
        Faunas.registerSpawnPlacement(event, GAZELLE);
        Faunas.registerSpawnPlacement(event, GROUSE);
        Faunas.registerSpawnPlacement(event, PHEASANT);
        Faunas.registerSpawnPlacement(event, TURKEY);
        Faunas.registerSpawnPlacement(event, PEAFOWL);
        Faunas.registerSpawnPlacement(event, DONKEY);
        Faunas.registerSpawnPlacement(event, MULE);
        Faunas.registerSpawnPlacement(event, HORSE);
        Faunas.registerSpawnPlacement(event, WOLF);
        Faunas.registerSpawnPlacement(event, HYENA);
        Faunas.registerSpawnPlacement(event, DIREWOLF);
    }

    private static <E extends Mob> FaunaType<E> registerAnimal(RegistryObject<EntityType<E>> entity) {
        return Faunas.register(entity, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
    }

    private static <E extends Mob> FaunaType<E> registerFish(RegistryObject<EntityType<E>> entity) {
        return Faunas.register(entity, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
    }

    private static <E extends Mob> FaunaType<E> registerAmphibiousPredator(RegistryObject<EntityType<E>> entity) {
        return Faunas.register(entity, SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
    }

    private static <E extends Mob> FaunaType<E> register(RegistryObject<EntityType<E>> entity, SpawnPlacements.Type spawnPlacement, Heightmap.Types heightmapType) {
        RegisteredDataManager.Entry<Fauna> fauna = Fauna.MANAGER.register(entity.getId());
        return new FaunaType<E>(entity, (Supplier<Fauna>)fauna, spawnPlacement, heightmapType);
    }

    private static <E extends Mob> void registerSpawnPlacement(SpawnPlacementRegisterEvent event, FaunaType<E> type) {
        event.register(type.entity().get(), type.spawnPlacementType(), type.heightmapType(), (mob, level, heightmap, pos, rand) -> {
            AquaticMob aquaticMob;
            Fauna fauna = type.fauna().get();
            ChunkGenerator generator = level.m_6018_().m_7726_().m_8481_();
            if (rand.m_188503_(fauna.getChance()) != 0) {
                return false;
            }
            if (mob instanceof AquaticMob && !(aquaticMob = (AquaticMob)mob).canSpawnIn(level.m_6425_(pos).m_76152_())) {
                return false;
            }
            int seaLevel = generator.m_6337_();
            if (fauna.getDistanceBelowSeaLevel() != -1 && pos.m_123342_() > seaLevel - fauna.getDistanceBelowSeaLevel()) {
                return false;
            }
            ChunkData data = EntityHelpers.getChunkDataForSpawning(level, pos);
            if (!fauna.getClimate().isValid(data, pos, rand)) {
                return false;
            }
            BlockPos below = pos.m_7495_();
            if (fauna.isSolidGround() && !Helpers.isBlock(level.m_8055_(below), (TagKey<Block>)BlockTags.f_13048_)) {
                return false;
            }
            return fauna.getMaxBrightness() == -1 || level.m_45524_(pos, 0) <= fauna.getMaxBrightness();
        }, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    record FaunaType<E extends Mob>(Supplier<EntityType<E>> entity, Supplier<Fauna> fauna, SpawnPlacements.Type spawnPlacementType, Heightmap.Types heightmapType) {
    }
}

