/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.wood.ScribingTableBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.util.Helpers;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ScribingTableContainer
extends ItemCombinerMenu {
    @Nullable
    private String itemName;

    public static boolean isInkInput(ItemStack stack) {
        return !ScribingTableContainer.getInkFluid(stack).isEmpty() || Helpers.isItem(stack, TFCTags.Items.SCRIBING_INK);
    }

    public static FluidStack getInkFluid(ItemStack stack) {
        return stack.getCapability(Capabilities.FLUID_ITEM).map(ScribingTableContainer::getInkFluid).orElse(FluidStack.EMPTY);
    }

    public static FluidStack getInkFluid(IFluidHandlerItem handler) {
        for (int tank = 0; tank < handler.getTanks(); ++tank) {
            FluidStack fluidStack = handler.getFluidInTank(tank);
            if (!Helpers.isFluid(fluidStack.getFluid(), TFCTags.Fluids.SCRIBING_INK) || fluidStack.getAmount() < 1000) continue;
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    public ScribingTableContainer(Inventory playerInv, int windowId) {
        this(playerInv, windowId, ContainerLevelAccess.f_39287_);
    }

    public ScribingTableContainer(Inventory playerInv, int windowId, ContainerLevelAccess access) {
        super((MenuType)TFCContainerTypes.SCRIBING_TABLE.get(), windowId, playerInv, access);
    }

    protected boolean m_6560_(Player player, boolean hasItem) {
        return player.m_150110_().f_35937_ || ScribingTableContainer.isInkInput(this.f_39769_.m_8020_(1));
    }

    protected void m_142365_(Player player, ItemStack stack) {
        this.f_39769_.m_6836_(0, ItemStack.f_41583_);
        ItemStack dye = this.f_39769_.m_8020_(1);
        this.f_39769_.m_6836_(1, dye.getCapability(Capabilities.FLUID_ITEM).map(handler -> {
            handler.drain(new FluidStack(ScribingTableContainer.getInkFluid(handler), 1000), IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }).orElseGet(() -> {
            ItemStack result = dye.m_41777_();
            result.m_41774_(1);
            return result;
        }));
        this.f_39770_.m_39292_((level, pos) -> Helpers.playSound(level, pos, (SoundEvent)TFCSounds.SCRIBING_TABLE.get()));
    }

    protected boolean m_8039_(BlockState state) {
        return state.m_60734_() instanceof ScribingTableBlock;
    }

    public void m_6640_() {
        ItemStack input = this.f_39769_.m_8020_(0);
        ItemStack output = input.m_41777_();
        if (StringUtils.isBlank((CharSequence)this.itemName)) {
            if (input.m_41788_()) {
                output.m_41787_();
            } else {
                output = ItemStack.f_41583_;
            }
        } else if (!this.itemName.equals(input.m_41786_().getString())) {
            output.m_41714_((Component)Component.m_237113_((String)this.itemName));
        } else {
            output = ItemStack.f_41583_;
        }
        this.f_39768_.m_6836_(0, output);
        this.m_38946_();
    }

    protected ItemCombinerMenuSlotDefinition m_266183_() {
        return ItemCombinerMenuSlotDefinition.m_266303_().m_266197_(0, 27, 47, s -> true).m_266197_(1, 76, 47, s -> true).m_266198_(2, 134, 47).m_266441_();
    }

    public void setItemName(String text) {
        this.itemName = text;
        if (this.m_38853_(2).m_6657_()) {
            ItemStack itemstack = this.m_38853_(2).m_7993_();
            if (StringUtils.isBlank((CharSequence)text)) {
                itemstack.m_41787_();
            } else {
                itemstack.m_41714_((Component)Component.m_237113_((String)this.itemName));
            }
        }
        this.m_6640_();
    }
}

