/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import java.util.Objects;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.MoldLike;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.container.CallbackSlot;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.common.container.ItemStackContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class MoldLikeAlloyContainer
extends ItemStackContainer
implements ISlotCallback {
    @Nullable
    private final MoldLike mold;
    private final IItemHandlerModifiable inventory;

    public static MoldLikeAlloyContainer create(ItemStack stack, InteractionHand hand, int slot, Inventory playerInv, int windowId) {
        return (MoldLikeAlloyContainer)new MoldLikeAlloyContainer(stack, hand, slot, playerInv, windowId).init(playerInv);
    }

    private MoldLikeAlloyContainer(ItemStack stack, InteractionHand hand, int slot, Inventory playerInv, int windowId) {
        super((MenuType)TFCContainerTypes.MOLD_LIKE_ALLOY.get(), windowId, playerInv, stack, hand, slot);
        this.mold = MoldLike.get(stack);
        this.inventory = new InventoryItemHandler(this, 1);
    }

    public void m_38946_() {
        if (this.mold != null && this.mold.isMolten()) {
            ItemStack outputStack = this.inventory.getStackInSlot(0);
            outputStack.getCapability(Capabilities.FLUID).ifPresent(outputFluidCap -> {
                int filled;
                FluidStack drained = this.mold.drain(1, IFluidHandler.FluidAction.SIMULATE);
                if (!drained.isEmpty() && (filled = outputFluidCap.fill(drained, IFluidHandler.FluidAction.EXECUTE)) == 1) {
                    Metal metal = Objects.requireNonNullElse(Metal.get(drained.getFluid()), Metal.unknown());
                    @Nullable IHeat outputHeat = HeatCapability.get(outputStack);
                    float heatCapacityOf1mB = metal.getHeatCapacity(1.0f);
                    this.mold.drain(1, IFluidHandler.FluidAction.EXECUTE);
                    if (outputHeat != null) {
                        outputHeat.addTemperatureFromSourceWithHeatCapacity(this.mold.getTemperature(), heatCapacityOf1mB);
                    }
                }
            });
        }
        super.m_38946_();
    }

    public void m_6877_(Player player) {
        ItemStack stack;
        if (!player.m_9236_().m_5776_() && !(stack = this.inventory.getStackInSlot(0)).m_41619_()) {
            this.giveItemStackToPlayerOrDrop(player, stack);
        }
        super.m_6877_(player);
    }

    @Override
    public boolean m_6875_(Player player) {
        return this.mold != null && (this.mold.isMolten() || this.mold.getFluidInTank(0).isEmpty()) && super.m_6875_(player);
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new IncompatibleClassChangeError();
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (!this.m_38903_(stack, 0, 1, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> !this.m_38903_(stack, this.containerSlots, this.f_38839_.size(), false);
        };
    }

    @Override
    protected void addContainerSlots() {
        if (this.mold != null) {
            this.m_38897_((Slot)new CallbackSlot(this, (IItemHandler)this.inventory, 0, 80, 34));
        }
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.mightHaveCapability(stack, Capabilities.FLUID);
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }
}

