/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public final class CountBlockCommand {
    private static final String DONE = "tfc.commands.count_block.done";

    public static LiteralArgumentBuilder<CommandSourceStack> create(CommandBuildContext cmdContext) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"count").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)250)).then(Commands.m_82129_((String)"block", (ArgumentType)BlockPredicateArgument.m_234627_((CommandBuildContext)cmdContext)).executes(context -> CountBlockCommand.countBlock((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"), BlockPredicateArgument.m_115573_((CommandContext)context, (String)"block")))));
    }

    private static int countBlock(CommandSourceStack source, int radius, Predicate<BlockInWorld> block) {
        ServerLevel level = source.m_81372_();
        BlockPos center = BlockPos.m_274446_((Position)source.m_81371_());
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        int found = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = level.m_141937_(); y < level.m_151558_(); ++y) {
                    cursor.m_122190_((Vec3i)center).m_122184_(x, 0, z).m_142448_(y);
                    if (!block.test(new BlockInWorld((LevelReader)level, (BlockPos)cursor, true))) continue;
                    ++found;
                }
            }
        }
        int finalFound = found;
        source.m_288197_(() -> Component.m_237110_((String)DONE, (Object[])new Object[]{finalFound}), true);
        return 1;
    }
}

