/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.world.feature.vein.IVeinConfig;
import net.dries007.tfc.world.feature.vein.VeinFeature;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.command.EnumArgument;

public final class ClearWorldCommand {
    private static final String STARTING = "tfc.commands.clear_world.starting";
    private static final String DONE = "tfc.commands.clear_world.done";

    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"clearworld").requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)250)).then(Commands.m_82129_((String)"preset", (ArgumentType)EnumArgument.enumArgument(Preset.class)).executes(cmd -> ClearWorldCommand.clearWorld((CommandSourceStack)cmd.getSource(), IntegerArgumentType.getInteger((CommandContext)cmd, (String)"radius"), (Preset)((Object)((Object)cmd.getArgument("preset", Preset.class))))))).executes(cmd -> ClearWorldCommand.clearWorld((CommandSourceStack)cmd.getSource(), IntegerArgumentType.getInteger((CommandContext)cmd, (String)"radius"), Preset.ALL)));
    }

    private static int clearWorld(CommandSourceStack source, int radius, Preset preset) {
        source.m_288197_(() -> Component.m_237115_((String)STARTING), true);
        ServerLevel level = source.m_81372_();
        BlockPos center = BlockPos.m_274446_((Position)source.m_81371_());
        BlockState air = Blocks.f_50016_.m_49966_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        Predicate<BlockState> predicate = preset.make(source.m_81377_());
        int minY = level.m_141937_();
        int blocksRemoved = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int height = level.m_6924_(Heightmap.Types.WORLD_SURFACE, center.m_123341_() + x, center.m_123343_() + z);
                for (int y = minY; y < height; ++y) {
                    mutablePos.m_122190_((Vec3i)center).m_122184_(x, 0, z).m_142448_(y);
                    BlockState state = level.m_8055_((BlockPos)mutablePos);
                    if (state.m_60795_() || !predicate.test(state)) continue;
                    level.m_7731_((BlockPos)mutablePos, air, 18);
                    ++blocksRemoved;
                }
            }
        }
        int finalBlocksRemoved = blocksRemoved;
        source.m_288197_(() -> Component.m_237110_((String)DONE, (Object[])new Object[]{finalBlocksRemoved}), true);
        return 1;
    }

    static enum Preset {
        ALL(server -> state -> true),
        RAW_ROCK(server -> {
            Set blocks = TFCBlocks.ROCK_BLOCKS.values().stream().map(map -> (Block)((RegistryObject)map.get((Object)Rock.BlockType.RAW)).get()).collect(Collectors.toSet());
            return state -> blocks.contains(state.m_60734_());
        }),
        EARTH(server -> {
            Set blocks = Stream.of(Stream.of(Rock.BlockType.RAW, Rock.BlockType.HARDENED, Rock.BlockType.GRAVEL).flatMap(t -> TFCBlocks.ROCK_BLOCKS.values().stream().map(map -> (Block)((RegistryObject)map.get(t)).get())), TFCBlocks.SOIL.get((Object)SoilBlockType.DIRT).values().stream().map(Supplier::get), TFCBlocks.SOIL.get((Object)SoilBlockType.GRASS).values().stream().map(Supplier::get), TFCBlocks.SAND.values().stream().map(Supplier::get)).flatMap(t -> t).collect(Collectors.toSet());
            return state -> blocks.contains(state.m_60734_());
        }),
        NOT_ORE(server -> {
            Registry registry = server.m_206579_().m_175515_(Registries.f_256911_);
            Set blocks = registry.m_123024_().filter(feature -> feature.f_65377_() instanceof VeinFeature).flatMap(feature -> ((IVeinConfig)feature.f_65378_()).config().states().values().stream().flatMap(weighted -> weighted.values().stream())).map(BlockBehaviour.BlockStateBase::m_60734_).collect(Collectors.toSet());
            return state -> !blocks.contains(state.m_60734_());
        });

        private final Function<MinecraftServer, Predicate<BlockState>> factory;

        private Preset(Function<MinecraftServer, Predicate<BlockState>> factory) {
            this.factory = factory;
        }

        Predicate<BlockState> make(MinecraftServer server) {
            return this.factory.apply(server);
        }
    }
}

