/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.player;

import net.dries007.tfc.common.capabilities.food.TFCFoodData;
import net.dries007.tfc.common.capabilities.player.PlayerDataCapability;
import net.dries007.tfc.common.recipes.ChiselRecipe;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.network.PlayerDataUpdatePacket;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerData
implements ICapabilitySerializable<CompoundTag> {
    public static final long MAX_INTOXICATED_TICKS = 36000L;
    private final Player player;
    private final LazyOptional<PlayerData> capability;
    @Nullable
    private CompoundTag delayedFoodNbt;
    private long lastDrinkTick;
    private long intoxicationTick;
    private ChiselRecipe.Mode chiselMode = ChiselRecipe.Mode.SMOOTH;

    public static PlayerData get(Player player) {
        return (PlayerData)player.getCapability(PlayerDataCapability.CAPABILITY).orElseThrow(() -> new IllegalStateException("Missing " + PlayerData.class));
    }

    public PlayerData(Player player) {
        this.player = player;
        this.capability = LazyOptional.of(() -> this);
    }

    @Deprecated
    public long getIntoxicatedTicks(boolean isClientSide) {
        return this.getIntoxicatedTicks();
    }

    public long getIntoxicatedTicks() {
        return Math.max(0L, this.intoxicationTick - Calendars.get(this.player.m_9236_().f_46443_).getTicks());
    }

    public void addIntoxicatedTicks(long ticks) {
        long currentTick = Calendars.SERVER.getTicks();
        if (this.intoxicationTick < currentTick) {
            this.intoxicationTick = currentTick;
        }
        this.intoxicationTick += ticks;
        if (this.intoxicationTick > currentTick + 36000L) {
            this.intoxicationTick = currentTick + 36000L;
        }
        this.sync();
    }

    public long getLastDrinkTick() {
        return this.lastDrinkTick;
    }

    public void setLastDrinkTick(long lastDrinkTick) {
        this.lastDrinkTick = lastDrinkTick;
        this.sync();
    }

    public ChiselRecipe.Mode getChiselMode() {
        return this.chiselMode;
    }

    public void cycleChiselMode() {
        this.chiselMode = this.chiselMode.next();
        this.sync();
    }

    public void setChiselMode(ChiselRecipe.Mode mode) {
        this.chiselMode = mode;
        this.sync();
    }

    public void sync() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> serverPlayer), new PlayerDataUpdatePacket(this.lastDrinkTick, this.intoxicationTick, this.chiselMode));
        }
    }

    public void updateFromPacket(long lastDrinkTick, long intoxicationTick, ChiselRecipe.Mode mode) {
        this.lastDrinkTick = lastDrinkTick;
        this.intoxicationTick = intoxicationTick;
        this.chiselMode = mode;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return PlayerDataCapability.CAPABILITY.orEmpty(cap, this.capability);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        FoodData foodData = this.player.m_36324_();
        if (foodData instanceof TFCFoodData) {
            TFCFoodData data = (TFCFoodData)foodData;
            nbt.m_128365_("food", (Tag)data.serializeToPlayerData());
        }
        nbt.m_128356_("lastDrinkTick", this.lastDrinkTick);
        nbt.m_128356_("intoxicationTick", this.intoxicationTick);
        nbt.m_128405_("chiselMode", this.chiselMode.ordinal());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.delayedFoodNbt = nbt.m_128425_("food", 10) ? nbt.m_128469_("food") : null;
        FoodData foodData = this.player.m_36324_();
        if (foodData instanceof TFCFoodData) {
            TFCFoodData data = (TFCFoodData)foodData;
            this.writeTo(data);
        }
        this.lastDrinkTick = nbt.m_128454_("lastDrinkTick");
        this.intoxicationTick = nbt.m_128454_("intoxicationTick");
        this.chiselMode = ChiselRecipe.Mode.valueOf(nbt.m_128451_("chiselMode"));
    }

    public void writeTo(TFCFoodData stats) {
        if (this.delayedFoodNbt != null) {
            stats.deserializeFromPlayerData(this.delayedFoodNbt);
            this.delayedFoodNbt = null;
        }
    }
}

