/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.heat;

import java.util.Iterator;
import net.dries007.tfc.common.capabilities.heat.HeatDefinition;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.capabilities.heat.IHeatBlock;
import net.dries007.tfc.common.capabilities.heat.INetworkHeat;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.Fuel;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.ItemDefinition;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public final class HeatCapability {
    public static final Capability<IHeat> CAPABILITY = Helpers.capability(new CapabilityToken<IHeat>(){});
    public static final ResourceLocation KEY = Helpers.identifier("item_heat");
    public static final Capability<IHeatBlock> BLOCK_CAPABILITY = Helpers.capability(new CapabilityToken<IHeatBlock>(){});
    public static final ResourceLocation BLOCK_KEY = Helpers.identifier("block_heat");
    public static final Capability<INetworkHeat> NETWORK_CAPABILITY = Helpers.capability(new CapabilityToken<INetworkHeat>(){});
    public static final DataManager<HeatDefinition> MANAGER = new DataManager<HeatDefinition>(Helpers.identifier("item_heats"), "item heat", HeatDefinition::new, HeatDefinition::new, HeatDefinition::encode, Packet::new);
    public static final IndirectHashCollection<Item, HeatDefinition> CACHE = IndirectHashCollection.create(ItemDefinition::getValidItems, MANAGER::getValues);
    public static final float POTTERY_HEAT_CAPACITY = 1.2f;

    @Nullable
    public static IHeat get(ItemStack stack) {
        return Helpers.getCapability((ICapabilityProvider)stack, CAPABILITY);
    }

    public static float getTemperature(ItemStack stack) {
        @Nullable IHeat heat = HeatCapability.get(stack);
        return heat != null ? heat.getTemperature() : 0.0f;
    }

    public static void setTemperature(ItemStack stack, float temperature) {
        @Nullable IHeat heat = HeatCapability.get(stack);
        if (heat != null) {
            heat.setTemperature(temperature);
        }
    }

    public static boolean has(ItemStack stack) {
        return stack.getCapability(CAPABILITY).isPresent();
    }

    public static boolean maybeHas(ItemStack stack) {
        return Helpers.mightHaveCapability(stack, CAPABILITY);
    }

    public static boolean isHot(ItemStack stack) {
        @Nullable IHeat heat = HeatCapability.get(stack);
        return heat != null && heat.getTemperature() > 0.0f;
    }

    @Nullable
    public static HeatDefinition getDefinition(ItemStack stack) {
        for (HeatDefinition def : CACHE.getAll(stack.m_41720_())) {
            if (!def.matches(stack)) continue;
            return def;
        }
        return null;
    }

    public static float adjustTempTowards(float temp, float target) {
        return HeatCapability.adjustTempTowards(temp, target, 1.0f, 1.0f);
    }

    public static float adjustTempTowards(float temp, float target, float delta) {
        return HeatCapability.adjustTempTowards(temp, target, delta, delta);
    }

    public static float adjustTempTowards(float temp, float target, float deltaPositive, float deltaNegative) {
        float delta = ((Double)TFCConfig.SERVER.deviceHeatingModifier.get()).floatValue();
        if (temp < target) {
            return Math.min(temp + delta * deltaPositive, target);
        }
        if (temp > target) {
            return Math.max(temp - delta * deltaNegative, target);
        }
        return target;
    }

    public static float adjustDeviceTemp(float temp, float baseTarget, int airTicks, boolean isRaining) {
        float target = HeatCapability.targetDeviceTemp(baseTarget, airTicks, isRaining);
        if (temp != target) {
            float deltaPositive = 1.0f;
            float deltaNegative = 1.0f;
            if (airTicks > 0) {
                deltaPositive = 2.0f;
                deltaNegative = 0.5f;
            }
            return HeatCapability.adjustTempTowards(temp, target, deltaPositive, deltaNegative);
        }
        return target;
    }

    public static float targetDeviceTemp(float target, int airTicks, boolean isRaining) {
        if (airTicks > 0) {
            float airInfluence = 4.0f * (float)airTicks;
            if (airInfluence > 600.0f) {
                airInfluence = 600.0f;
            }
            target += Math.min(airInfluence, target * 0.5f);
        }
        if (isRaining && (target -= 300.0f) < 0.0f) {
            target = 0.0f;
        }
        return target;
    }

    public static float adjustTemp(float temperature, float heatCapacity, long ticksSinceUpdate) {
        if (ticksSinceUpdate <= 0L) {
            return temperature;
        }
        float newTemperature = temperature - (float)((double)ticksSinceUpdate * (Double)TFCConfig.SERVER.itemCoolingModifier.get()) / heatCapacity;
        return newTemperature < 0.0f ? 0.0f : newTemperature;
    }

    public static void addTemp(IHeat instance, float target) {
        HeatCapability.addTemp(instance, target, 3.0f);
    }

    public static void addTemp(IHeat instance, float target, float modifier) {
        float temp = instance.getTemperature() + (((Double)TFCConfig.SERVER.itemCoolingModifier.get()).floatValue() - 1.0f + modifier * ((Double)TFCConfig.SERVER.itemHeatingModifier.get()).floatValue()) / instance.getHeatCapacity();
        if (temp > target) {
            temp = target;
        }
        instance.setTemperatureIfWarmer(temp);
    }

    public static Remainder consumeFuelForTicks(long ticks, IItemHandlerModifiable inventory, int burnTicks, float burnTemperature, int slotStart, int slotEnd) {
        return HeatCapability.consumeFuelForTicks(ticks, burnTicks, burnTemperature, Helpers.iterate((IItemHandler)inventory, slotStart, 1 + slotEnd));
    }

    public static Remainder consumeFuelForTicks(long ticks, int burnTicks, float burnTemperature, Iterable<ItemStack> fuelStacks) {
        if ((long)burnTicks > ticks) {
            burnTicks = (int)((long)burnTicks - ticks);
            return new Remainder(burnTicks, burnTemperature, 0L);
        }
        ticks -= (long)burnTicks;
        burnTicks = 0;
        Iterator<ItemStack> iterator = fuelStacks.iterator();
        while (iterator.hasNext()) {
            ItemStack fuelStack = iterator.next();
            Fuel fuel = Fuel.get(fuelStack);
            if (fuel == null) continue;
            iterator.remove();
            if ((long)fuel.getDuration() > ticks) {
                burnTicks = (int)((long)fuel.getDuration() - ticks);
                burnTemperature = fuel.getTemperature();
                return new Remainder(burnTicks, burnTemperature, 0L);
            }
            ticks -= (long)fuel.getDuration();
        }
        return new Remainder(burnTicks, burnTemperature, ticks);
    }

    public static void provideHeatTo(Level level, BlockPos pos, float temperature) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity != null) {
            entity.getCapability(BLOCK_CAPABILITY).ifPresent(cap -> cap.setTemperatureIfWarmer(temperature));
        }
    }

    public record Remainder(int burnTicks, float burnTemperature, long ticks) {
    }

    public static class Packet
    extends DataManagerSyncPacket<HeatDefinition> {
    }
}

