/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.glass;

import java.util.List;
import net.dries007.tfc.common.capabilities.glass.GlassOperation;
import net.dries007.tfc.common.capabilities.glass.GlassOperations;
import net.dries007.tfc.util.Helpers;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GlassWorkData {
    private static final String KEY = "tfc:glass_work_data";
    private final GlassOperations operations = new GlassOperations();
    private ItemStack batch = ItemStack.f_41583_;

    public static void addTooltipInfo(ItemStack stack, List<Component> tooltips) {
        GlassWorkData data = GlassWorkData.get(stack);
        if (data != null) {
            tooltips.add(data.batch.m_41786_());
            if (!data.operations.getSteps().isEmpty()) {
                tooltips.add((Component)Component.m_237115_((String)"tfc.tooltip.glass.title").m_130940_(ChatFormatting.AQUA));
                for (GlassOperation operation : data.operations.getSteps()) {
                    tooltips.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)Helpers.translateEnum(operation)));
                }
            }
        }
    }

    @Nullable
    public static GlassWorkData get(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(KEY, 10)) {
            return new GlassWorkData().read(tag.m_128469_(KEY));
        }
        return null;
    }

    public static void apply(ItemStack stack, GlassOperation operation) {
        GlassWorkData data = GlassWorkData.get(stack);
        if (data == null) {
            data = GlassWorkData.attach(stack);
        }
        data.getOperations().apply(operation);
        stack.m_41784_().m_128365_(KEY, (Tag)data.write());
    }

    public static void createNewBatch(ItemStack stack, ItemStack glass) {
        GlassWorkData data = new GlassWorkData();
        data.batch = glass.m_41777_();
        stack.m_41784_().m_128365_(KEY, (Tag)data.write());
    }

    public static void clear(ItemStack stack) {
        stack.m_41749_(KEY);
    }

    private static GlassWorkData attach(ItemStack stack) {
        GlassWorkData data = new GlassWorkData();
        stack.m_41784_().m_128365_(KEY, (Tag)data.write());
        return data;
    }

    private GlassWorkData() {
    }

    public GlassOperations getOperations() {
        return this.operations;
    }

    public ItemStack getBatch() {
        return this.batch;
    }

    private CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        this.operations.write(tag);
        tag.m_128365_("stack", (Tag)this.batch.m_41739_(new CompoundTag()));
        return tag;
    }

    private GlassWorkData read(CompoundTag tag) {
        this.operations.read(tag);
        this.batch = ItemStack.m_41712_((CompoundTag)tag.m_128469_("stack"));
        return this;
    }
}

