/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.Direction;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public interface SidedHandler<T> {
    public T getSidedHandler(@Nullable Direction var1);

    public static class Noop<T>
    implements SidedHandler<LazyOptional<T>> {
        private final LazyOptional<T> internal = LazyOptional.of(() -> internal);

        public Noop(T internal) {
        }

        public void invalidate() {
            this.internal.invalidate();
        }

        @Override
        public LazyOptional<T> getSidedHandler(@Nullable Direction side) {
            return this.internal;
        }
    }

    public static class Builder<T>
    implements SidedHandler<LazyOptional<T>> {
        private static final int SIDES = Direction.values().length;
        private final LazyOptional<T> internal;
        private final LazyOptional<T>[] sidedHandlers;
        private final List<LazyOptional<T>> handlers;

        public Builder(@Nullable T internal) {
            this.internal = internal == null ? LazyOptional.empty() : LazyOptional.of(() -> internal);
            this.sidedHandlers = new LazyOptional[SIDES];
            this.handlers = new ArrayList<LazyOptional<T>>();
            this.handlers.add(this.internal);
        }

        public void invalidate() {
            this.handlers.forEach(LazyOptional::invalidate);
        }

        public Builder<T> on(T handler, Predicate<Direction> sides) {
            LazyOptional optional = LazyOptional.of(() -> handler);
            for (Direction side : Helpers.DIRECTIONS) {
                if (!sides.test(side)) continue;
                this.sidedHandlers[side.ordinal()] = optional;
            }
            this.handlers.add(optional);
            return this;
        }

        public Builder<T> on(T handler, Direction ... sides) {
            LazyOptional optional = LazyOptional.of(() -> handler);
            for (Direction side : sides) {
                this.sidedHandlers[side.ordinal()] = optional;
            }
            this.handlers.add(optional);
            return this;
        }

        @Override
        public LazyOptional<T> getSidedHandler(@Nullable Direction side) {
            if (side == null) {
                return this.internal;
            }
            LazyOptional<T> sided = this.sidedHandlers[side.ordinal()];
            return sided == null ? LazyOptional.empty() : sided;
        }
    }
}

