/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities;

import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public final class ItemStackCapabilitySync {
    private static final String FOOD_ID = "tfc:food";
    private static final String HEAT_ID = "tfc:heat";
    private static final String EMPTY_ID = "tfc:empty";

    public static boolean hasSyncableCapability(ItemStack stack) {
        return stack.getCapability(FoodCapability.NETWORK_CAPABILITY).isPresent() || stack.getCapability(HeatCapability.NETWORK_CAPABILITY).isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CompoundTag writeToNetwork(ItemStack stack, @Nullable CompoundTag originalTag) {
        ItemStack itemStack = stack;
        synchronized (itemStack) {
            if (ItemStackCapabilitySync.hasSyncableCapability(stack)) {
                CompoundTag writableTag;
                CompoundTag compoundTag = writableTag = originalTag == null ? new CompoundTag() : originalTag.m_6426_();
                if (originalTag != null && originalTag.m_128456_()) {
                    writableTag.m_128379_(EMPTY_ID, true);
                }
                ItemStackCapabilitySync.writeToNetwork(FOOD_ID, FoodCapability.NETWORK_CAPABILITY, stack, writableTag);
                ItemStackCapabilitySync.writeToNetwork(HEAT_ID, HeatCapability.NETWORK_CAPABILITY, stack, writableTag);
                return writableTag;
            }
        }
        return originalTag;
    }

    public static void readFromNetwork(ItemStack stack, @Nullable CompoundTag tag) {
        if (tag != null) {
            @Nullable CompoundTag foodTag = ItemStackCapabilitySync.readTagFromNetwork(FOOD_ID, tag);
            @Nullable CompoundTag heatTag = ItemStackCapabilitySync.readTagFromNetwork(HEAT_ID, tag);
            if (foodTag != null || heatTag != null) {
                boolean wasEmptyButPresent = tag.m_128471_(EMPTY_ID);
                tag.m_128473_(EMPTY_ID);
                if (!wasEmptyButPresent && tag.m_128456_()) {
                    tag = null;
                }
            }
            stack.readShareTag(tag);
            ItemStackCapabilitySync.readCapabilityFromTag(foodTag, FoodCapability.NETWORK_CAPABILITY, stack);
            ItemStackCapabilitySync.readCapabilityFromTag(heatTag, HeatCapability.NETWORK_CAPABILITY, stack);
        }
    }

    private static void writeToNetwork(String networkId, Capability<? extends INBTSerializable<CompoundTag>> capability, ItemStack stack, CompoundTag rootTag) {
        stack.getCapability(capability).map(INBTSerializable::serializeNBT).ifPresent(tag -> rootTag.m_128365_(networkId, (Tag)tag));
    }

    @Nullable
    private static CompoundTag readTagFromNetwork(String networkId, CompoundTag tag) {
        if (tag.m_128425_(networkId, 10)) {
            CompoundTag subTag = tag.m_128469_(networkId);
            tag.m_128473_(networkId);
            return subTag;
        }
        return null;
    }

    private static void readCapabilityFromTag(@Nullable CompoundTag tag, Capability<? extends INBTSerializable<CompoundTag>> capability, ItemStack stack) {
        if (tag != null) {
            stack.getCapability(capability).ifPresent(cap -> cap.deserializeNBT((Tag)tag));
        }
    }
}

