/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blockentities.LoomBlockEntity;
import net.dries007.tfc.common.blockentities.SluiceBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.rotation.WaterWheelBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.WindmillBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.GroundcoverBlock;
import net.dries007.tfc.common.blocks.JarShelfBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.common.blocks.devices.SluiceBlock;
import net.dries007.tfc.common.blocks.rotation.AxleBlock;
import net.dries007.tfc.common.blocks.rotation.BladedAxleBlock;
import net.dries007.tfc.common.blocks.rotation.ClutchBlock;
import net.dries007.tfc.common.blocks.rotation.EncasedAxleBlock;
import net.dries007.tfc.common.blocks.rotation.GearBoxBlock;
import net.dries007.tfc.common.blocks.rotation.WaterWheelBlock;
import net.dries007.tfc.common.blocks.rotation.WindmillBlock;
import net.dries007.tfc.common.blocks.wood.BookshelfBlock;
import net.dries007.tfc.common.blocks.wood.FallenLeavesBlock;
import net.dries007.tfc.common.blocks.wood.HorizontalSupportBlock;
import net.dries007.tfc.common.blocks.wood.LogBlock;
import net.dries007.tfc.common.blocks.wood.ScribingTableBlock;
import net.dries007.tfc.common.blocks.wood.SewingTableBlock;
import net.dries007.tfc.common.blocks.wood.TFCChestBlock;
import net.dries007.tfc.common.blocks.wood.TFCCraftingTableBlock;
import net.dries007.tfc.common.blocks.wood.TFCDoorBlock;
import net.dries007.tfc.common.blocks.wood.TFCFenceBlock;
import net.dries007.tfc.common.blocks.wood.TFCFenceGateBlock;
import net.dries007.tfc.common.blocks.wood.TFCLeavesBlock;
import net.dries007.tfc.common.blocks.wood.TFCLecternBlock;
import net.dries007.tfc.common.blocks.wood.TFCLoomBlock;
import net.dries007.tfc.common.blocks.wood.TFCPressurePlateBlock;
import net.dries007.tfc.common.blocks.wood.TFCSaplingBlock;
import net.dries007.tfc.common.blocks.wood.TFCSlabBlock;
import net.dries007.tfc.common.blocks.wood.TFCStairBlock;
import net.dries007.tfc.common.blocks.wood.TFCStandingSignBlock;
import net.dries007.tfc.common.blocks.wood.TFCTrapDoorBlock;
import net.dries007.tfc.common.blocks.wood.TFCTrappedChestBlock;
import net.dries007.tfc.common.blocks.wood.TFCWallSignBlock;
import net.dries007.tfc.common.blocks.wood.TFCWoodButtonBlock;
import net.dries007.tfc.common.blocks.wood.ToolRackBlock;
import net.dries007.tfc.common.blocks.wood.VerticalSupportBlock;
import net.dries007.tfc.common.items.BarrelBlockItem;
import net.dries007.tfc.common.items.ChestBlockItem;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryWood;
import net.dries007.tfc.world.feature.tree.TFCTreeGrower;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public enum Wood implements RegistryWood
{
    ACACIA(false, MapColor.f_283895_, MapColor.f_283907_, 11, 210),
    ASH(false, MapColor.f_283870_, MapColor.f_283895_, 7, 10),
    ASPEN(false, MapColor.f_283856_, MapColor.f_283919_, 8, 250),
    BIRCH(false, MapColor.f_283748_, MapColor.f_283919_, 7, 145),
    BLACKWOOD(false, MapColor.f_283927_, MapColor.f_283748_, 8, 80),
    CHESTNUT(false, MapColor.f_283798_, MapColor.f_283916_, 7, 40),
    DOUGLAS_FIR(true, MapColor.f_283843_, MapColor.f_283774_, 7, 0),
    HICKORY(false, MapColor.f_283774_, MapColor.f_283818_, 10, 230),
    KAPOK(false, MapColor.f_283889_, MapColor.f_283748_, 7, 30),
    MANGROVE(false, MapColor.f_283913_, MapColor.f_283748_, 8, 100),
    MAPLE(false, MapColor.f_283750_, MapColor.f_283861_, 7, 0),
    OAK(false, MapColor.f_283825_, MapColor.f_283748_, 10, 120),
    PALM(false, MapColor.f_283750_, MapColor.f_283748_, 7, 255),
    PINE(true, MapColor.f_283861_, MapColor.f_283818_, 7, 0),
    ROSEWOOD(false, MapColor.f_283913_, MapColor.f_283907_, 8, 170),
    SEQUOIA(true, MapColor.f_283798_, MapColor.f_283798_, 18, 0),
    SPRUCE(true, MapColor.f_283870_, MapColor.f_283771_, 7, 0),
    SYCAMORE(false, MapColor.f_283832_, MapColor.f_283778_, 8, 200),
    WHITE_CEDAR(true, MapColor.f_283919_, MapColor.f_283907_, 7, 0),
    WILLOW(false, MapColor.f_283784_, MapColor.f_283774_, 11, 225);

    public static final Wood[] VALUES;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final boolean conifer;
    private final MapColor woodColor;
    private final MapColor barkColor;
    private final TFCTreeGrower tree;
    private final int daysToGrow;
    private final BlockSetType blockSet;
    private final WoodType woodType;
    private final int autumnIndex;

    private Wood(boolean conifer, MapColor woodColor, MapColor barkColor, int daysToGrow, int autumnIndex) {
        this.conifer = conifer;
        this.woodColor = woodColor;
        this.barkColor = barkColor;
        this.tree = new TFCTreeGrower(Helpers.identifier("tree/" + this.serializedName), Helpers.identifier("tree/" + this.serializedName + "_large"));
        this.daysToGrow = daysToGrow;
        this.autumnIndex = autumnIndex;
        this.blockSet = new BlockSetType(this.serializedName);
        this.woodType = new WoodType(Helpers.identifier(this.serializedName).toString(), this.blockSet);
    }

    public String m_7912_() {
        return this.serializedName;
    }

    public boolean isConifer() {
        return this.conifer;
    }

    @Override
    public BlockSetType getBlockSet() {
        return this.blockSet;
    }

    @Override
    public WoodType getVanillaWoodType() {
        return this.woodType;
    }

    @Override
    public MapColor woodColor() {
        return this.woodColor;
    }

    @Override
    public MapColor barkColor() {
        return this.barkColor;
    }

    @Override
    public TFCTreeGrower tree() {
        return this.tree;
    }

    @Override
    public int daysToGrow() {
        return (Integer)TFCConfig.SERVER.saplingGrowthDays.get(this).get();
    }

    @Override
    public int autumnIndex() {
        return this.autumnIndex;
    }

    public int defaultDaysToGrow() {
        return this.daysToGrow;
    }

    @Override
    public Supplier<Block> getBlock(BlockType type) {
        return (Supplier)TFCBlocks.WOODS.get(this).get((Object)type);
    }

    public static void registerBlockSetTypes() {
        for (Wood wood : VALUES) {
            BlockSetType.m_272115_((BlockSetType)wood.blockSet);
            WoodType.m_61844_((WoodType)wood.woodType);
        }
    }

    static {
        VALUES = Wood.values();
    }

    public static enum BlockType {
        LOG(false, (self, wood) -> new LogBlock(ExtendedProperties.of(state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? wood.woodColor() : wood.barkColor()).strength(8.0f).sound(SoundType.f_56736_).instrument(NoteBlockInstrument.BASS).requiresCorrectToolForDrops().flammableLikeLogs(), wood.getBlock(self.stripped()))),
        STRIPPED_LOG(false, wood -> new LogBlock(ExtendedProperties.of(state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? wood.woodColor() : wood.barkColor()).strength(7.5f).sound(SoundType.f_56736_).requiresCorrectToolForDrops().flammableLikeLogs(), null)),
        WOOD(false, (self, wood) -> new LogBlock(BlockType.properties(wood).strength(8.0f).requiresCorrectToolForDrops().flammableLikeLogs(), wood.getBlock(self.stripped()))),
        STRIPPED_WOOD(false, wood -> new LogBlock(BlockType.properties(wood).strength(7.5f).requiresCorrectToolForDrops().flammableLikeLogs(), null)),
        LEAVES(false, (self, wood) -> new TFCLeavesBlock(ExtendedProperties.of().mapColor(MapColor.f_283915_).strength(0.5f).sound(SoundType.f_56740_).defaultInstrument().randomTicks().noOcclusion().isViewBlocking(TFCBlocks::never).flammableLikeLeaves(), wood.autumnIndex(), wood.getBlock(self.fallenLeaves()), wood.getBlock(self.twig()))),
        PLANKS(false, wood -> new ExtendedBlock(BlockType.properties(wood).strength(1.5f, 3.0f).flammableLikePlanks())),
        SAPLING(false, wood -> new TFCSaplingBlock(wood.tree(), ExtendedProperties.of(MapColor.f_283915_).noCollission().randomTicks().strength(0.0f).sound(SoundType.f_56740_).flammableLikeLeaves().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TICK_COUNTER), wood::daysToGrow, wood == PALM)),
        POTTED_SAPLING(false, wood -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, wood.getBlock(SAPLING), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50229_))),
        BOOKSHELF(true, wood -> new BookshelfBlock(BlockType.properties(wood).strength(2.0f, 3.0f).flammable(20, 30).enchantPower(BookshelfBlock::getEnchantPower).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BOOKSHELF))),
        DOOR(true, wood -> new TFCDoorBlock(BlockType.properties(wood).strength(3.0f).noOcclusion().flammableLikePlanks(), wood.getBlockSet())),
        TRAPDOOR(true, wood -> new TFCTrapDoorBlock(BlockType.properties(wood).strength(3.0f).noOcclusion().flammableLikePlanks(), wood.getBlockSet())),
        FENCE(true, wood -> new TFCFenceBlock(BlockType.properties(wood).strength(2.0f, 3.0f).flammableLikePlanks())),
        LOG_FENCE(true, wood -> new TFCFenceBlock(BlockType.properties(wood).strength(2.0f, 3.0f).flammableLikeLogs())),
        FENCE_GATE(true, wood -> new TFCFenceGateBlock(BlockType.properties(wood).strength(2.0f, 3.0f).flammableLikePlanks())),
        BUTTON(true, wood -> new TFCWoodButtonBlock(ExtendedProperties.of().noCollission().strength(0.5f).sound(SoundType.f_56736_).flammableLikePlanks(), wood.getBlockSet())),
        PRESSURE_PLATE(true, wood -> new TFCPressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockType.properties(wood).noCollission().strength(0.5f).sound(SoundType.f_56736_).flammableLikePlanks(), wood.getBlockSet())),
        SLAB(true, wood -> new TFCSlabBlock(BlockType.properties(wood).strength(1.5f, 3.0f).flammableLikePlanks())),
        STAIRS(true, wood -> new TFCStairBlock(() -> wood.getBlock(PLANKS).get().m_49966_(), BlockType.properties(wood).strength(1.5f, 3.0f).sound(SoundType.f_56736_).flammableLikePlanks())),
        TOOL_RACK(true, wood -> new ToolRackBlock(BlockType.properties(wood).strength(2.0f).noOcclusion().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TOOL_RACK))),
        TWIG(false, wood -> GroundcoverBlock.twig(ExtendedProperties.of().strength(0.05f, 0.0f).sound(SoundType.f_56736_).noCollission().flammableLikeWool())),
        FALLEN_LEAVES(false, (self, wood) -> new FallenLeavesBlock(ExtendedProperties.of().strength(0.05f, 0.0f).noOcclusion().noCollission().isViewBlocking(TFCBlocks::never).sound(SoundType.f_56758_).flammableLikeWool(), wood.getBlock(self.leaves()))),
        VERTICAL_SUPPORT(false, wood -> new VerticalSupportBlock(BlockType.properties(wood).strength(1.0f).noOcclusion().flammableLikeLogs())),
        HORIZONTAL_SUPPORT(false, wood -> new HorizontalSupportBlock(BlockType.properties(wood).strength(1.0f).noOcclusion().flammableLikeLogs())),
        WORKBENCH(true, wood -> new TFCCraftingTableBlock(BlockType.properties(wood).strength(2.5f).flammableLikeLogs())),
        TRAPPED_CHEST(false, (self, wood) -> new TFCTrappedChestBlock(BlockType.properties(wood).strength(2.5f).flammableLikeLogs().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TRAPPED_CHEST).clientTicks(ChestBlockEntity::m_155343_), wood.m_7912_()), (TriFunction<Block, Item.Properties, RegistryWood, ? extends BlockItem>)((TriFunction)ChestBlockItem::new)),
        CHEST(false, (self, wood) -> new TFCChestBlock(BlockType.properties(wood).strength(2.5f).flammableLikeLogs().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.CHEST).clientTicks(ChestBlockEntity::m_155343_), wood.m_7912_()), (TriFunction<Block, Item.Properties, RegistryWood, ? extends BlockItem>)((TriFunction)ChestBlockItem::new)),
        LOOM(true, (self, wood) -> new TFCLoomBlock(BlockType.properties(wood).strength(2.5f).noOcclusion().flammableLikePlanks().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.LOOM).ticks(LoomBlockEntity::tick), self.planksTexture((RegistryWood)wood))),
        SLUICE(false, wood -> new SluiceBlock(BlockType.properties(wood).strength(3.0f).noOcclusion().flammableLikeLogs().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.SLUICE).serverTicks(SluiceBlockEntity::serverTick))),
        SIGN(true, wood -> new TFCStandingSignBlock(BlockType.properties(wood).noCollission().strength(1.0f).flammableLikePlanks().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.SIGN).ticks(SignBlockEntity::m_276836_), wood.getVanillaWoodType())),
        WALL_SIGN(true, wood -> new TFCWallSignBlock(BlockType.properties(wood).noCollission().strength(1.0f).dropsLike(wood.getBlock(SIGN)).flammableLikePlanks().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.SIGN).ticks(SignBlockEntity::m_276836_), wood.getVanillaWoodType())),
        BARREL(false, (self, wood) -> new BarrelBlock(BlockType.properties(wood).strength(2.5f).flammableLikePlanks().noOcclusion().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BARREL).serverTicks(BarrelBlockEntity::serverTick)), BarrelBlockItem::new),
        LECTERN(false, wood -> new TFCLecternBlock(BlockType.properties(wood).noCollission().strength(2.5f).flammableLikePlanks().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.LECTERN))),
        SCRIBING_TABLE(false, wood -> new ScribingTableBlock(BlockType.properties(wood).noOcclusion().strength(2.5f).flammable(20, 30))),
        SEWING_TABLE(false, wood -> new SewingTableBlock(BlockType.properties(wood).noOcclusion().strength(2.5f).flammable(20, 30))),
        JAR_SHELF(false, wood -> new JarShelfBlock(BlockType.properties(wood).noOcclusion().strength(2.5f).flammableLikePlanks().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.JARS))),
        AXLE(false, (self, wood) -> new AxleBlock(BlockType.properties(wood).noOcclusion().strength(2.5f).flammableLikeLogs().pushReaction(PushReaction.DESTROY).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.AXLE), BlockType.getBlock(wood, self.windmill()), self.planksTexture((RegistryWood)wood))),
        BLADED_AXLE(false, (self, wood) -> new BladedAxleBlock(BlockType.properties(wood).noOcclusion().strength(2.5f).flammableLikeLogs().pushReaction(PushReaction.DESTROY).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BLADED_AXLE), BlockType.getBlock(wood, self.axle()))),
        ENCASED_AXLE(false, (self, wood) -> new EncasedAxleBlock(BlockType.properties(wood).strength(2.5f).flammableLikeLogs().pushReaction(PushReaction.DESTROY).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.ENCASED_AXLE))),
        CLUTCH(false, (self, wood) -> new ClutchBlock(BlockType.properties(wood).strength(2.5f).flammableLikeLogs().pushReaction(PushReaction.DESTROY).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.CLUTCH), BlockType.getBlock(wood, self.axle()))),
        GEAR_BOX(false, (self, wood) -> new GearBoxBlock(BlockType.properties(wood).strength(2.0f).noOcclusion().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.GEAR_BOX), BlockType.getBlock(wood, self.axle()))),
        WINDMILL(false, (self, wood) -> new WindmillBlock(BlockType.properties(wood).strength(9.0f).noOcclusion().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.WINDMILL).ticks(WindmillBlockEntity::serverTick, WindmillBlockEntity::clientTick), BlockType.getBlock(wood, self.axle()))),
        WATER_WHEEL(false, (self, wood) -> new WaterWheelBlock(BlockType.properties(wood).strength(9.0f).noOcclusion().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.WATER_WHEEL).ticks(WaterWheelBlockEntity::serverTick, WaterWheelBlockEntity::clientTick), BlockType.getBlock(wood, self.axle()), wood.m_7912_()));

        private final boolean isPlanksVariant;
        private final BiFunction<BlockType, RegistryWood, Block> blockFactory;
        private final TriFunction<Block, Item.Properties, RegistryWood, ? extends BlockItem> blockItemFactory;

        private static ExtendedProperties properties(RegistryWood wood) {
            return ExtendedProperties.of(wood.woodColor()).sound(SoundType.f_56736_).instrument(NoteBlockInstrument.BASS);
        }

        private static <B extends Block> Supplier<? extends B> getBlock(RegistryWood wood, BlockType type) {
            return wood.getBlock(type);
        }

        private BlockType(boolean isPlanksVariant, Function<RegistryWood, Block> blockFactory) {
            this(isPlanksVariant, (BlockType self, RegistryWood wood) -> (Block)blockFactory.apply((RegistryWood)wood));
        }

        private BlockType(boolean isPlanksVariant, BiFunction<BlockType, RegistryWood, Block> blockFactory) {
            this(isPlanksVariant, blockFactory, BlockItem::new);
        }

        private BlockType(boolean isPlanksVariant, BiFunction<BlockType, RegistryWood, Block> blockFactory, BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory) {
            this.blockFactory = blockFactory;
            this.isPlanksVariant = isPlanksVariant;
            this.blockItemFactory = (block, properties, self) -> (BlockItem)blockItemFactory.apply((Block)block, (Item.Properties)properties);
        }

        private BlockType(boolean isPlanksVariant, BiFunction<BlockType, RegistryWood, Block> blockFactory, TriFunction<Block, Item.Properties, RegistryWood, ? extends BlockItem> blockItemFactory) {
            this.blockFactory = blockFactory;
            this.isPlanksVariant = isPlanksVariant;
            this.blockItemFactory = blockItemFactory;
        }

        @Nullable
        public Function<Block, BlockItem> createBlockItem(RegistryWood wood, Item.Properties properties) {
            return this.needsItem() ? block -> (BlockItem)this.blockItemFactory.apply(block, (Object)properties, (Object)wood) : null;
        }

        public String nameFor(RegistryWood wood) {
            return (this.isPlanksVariant ? "wood/planks/" + wood.m_7912_() + "_" + this.name() : "wood/" + this.name() + "/" + wood.m_7912_()).toLowerCase(Locale.ROOT);
        }

        public boolean needsItem() {
            return this != VERTICAL_SUPPORT && this != HORIZONTAL_SUPPORT && this != SIGN && this != WALL_SIGN && this != POTTED_SAPLING && this != WINDMILL;
        }

        private BlockType stripped() {
            return switch (this) {
                case LOG -> STRIPPED_LOG;
                case WOOD -> STRIPPED_WOOD;
                default -> throw new IllegalStateException("Block type " + this.name() + " does not have a stripped variant");
            };
        }

        private ResourceLocation planksTexture(RegistryWood wood) {
            return Helpers.identifier("block/wood/planks/" + wood.m_7912_());
        }

        private BlockType twig() {
            return TWIG;
        }

        private BlockType fallenLeaves() {
            return FALLEN_LEAVES;
        }

        private BlockType leaves() {
            return LEAVES;
        }

        private BlockType axle() {
            return AXLE;
        }

        private BlockType windmill() {
            return WINDMILL;
        }

        public Supplier<Block> create(RegistryWood wood) {
            return () -> this.blockFactory.apply(this, wood);
        }
    }
}

