/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.CharcoalPileBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.GroundcoverBlock;
import net.dries007.tfc.common.blocks.ISlowEntities;
import net.dries007.tfc.common.blocks.wood.TFCLeavesBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FallenLeavesBlock
extends GroundcoverBlock
implements ISlowEntities {
    public static final int MAX_LAYERS = 8;
    public static final IntegerProperty LAYERS = BlockStateProperties.f_61417_;
    private final Supplier<? extends Block> leaves;

    public FallenLeavesBlock(ExtendedProperties properties, Supplier<? extends Block> leaves) {
        super(properties, Shapes.m_83144_(), null);
        this.leaves = leaves;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack item = player.m_21120_(hand);
        int layers = (Integer)state.m_61143_((Property)LAYERS);
        if (item.m_41720_() == this.m_5456_() && layers < 8) {
            if (!player.m_7500_()) {
                item.m_41774_(1);
            }
            BlockState toPlace = layers + 1 == 8 ? (BlockState)this.leaves.get().m_49966_().m_61124_((Property)TFCLeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)) : (BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(layers + 1));
            level.m_46597_(pos, toPlace);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (layers == 1 && item.m_41720_() != this.m_5456_()) {
            return super.m_6227_(state, level, pos, player, hand, result);
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if ((Integer)state.m_61143_((Property)LAYERS) == 8) {
            FluidState fluid = state.m_60819_();
            BlockState newState = (BlockState)this.leaves.get().m_49966_().m_61124_((Property)TFCLeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true));
            if ((newState = FluidHelpers.fillWithFluid(newState, fluid.m_76152_())) != null) {
                return newState;
            }
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    @Override
    public float slowEntityFactor(BlockState state) {
        return (Integer)state.m_61143_((Property)LAYERS) == 1 || !state.m_60819_().m_76178_() ? 1.0f : (float)((double)((float)((Integer)state.m_61143_((Property)LAYERS)).intValue() / 8.0f) * (Double)TFCConfig.SERVER.leavesMovementModifier.get());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{LAYERS}));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return CharcoalPileBlock.SHAPE_BY_LAYER[(Integer)state.m_61143_((Property)LAYERS)];
    }

    public Supplier<? extends Block> getLeaves() {
        return this.leaves;
    }
}

