/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.Nullable;

public final class BranchDirection
extends Enum<BranchDirection>
implements StringRepresentable {
    public static final /* enum */ BranchDirection NONE = new BranchDirection();
    public static final /* enum */ BranchDirection NORTH_WEST = new BranchDirection(Direction.NORTH, Direction.WEST);
    public static final /* enum */ BranchDirection NORTH = new BranchDirection(Direction.NORTH, null);
    public static final /* enum */ BranchDirection NORTH_EAST = new BranchDirection(Direction.NORTH, Direction.EAST);
    public static final /* enum */ BranchDirection WEST = new BranchDirection(null, Direction.WEST);
    public static final /* enum */ BranchDirection EAST = new BranchDirection(null, Direction.EAST);
    public static final /* enum */ BranchDirection SOUTH_WEST = new BranchDirection(Direction.SOUTH, Direction.WEST);
    public static final /* enum */ BranchDirection SOUTH = new BranchDirection(Direction.SOUTH, null);
    public static final /* enum */ BranchDirection SOUTH_EAST = new BranchDirection(Direction.SOUTH, Direction.EAST);
    public static final /* enum */ BranchDirection DOWN_NORTH_WEST = new BranchDirection(Direction.DOWN, Direction.NORTH, Direction.WEST);
    public static final /* enum */ BranchDirection DOWN_NORTH = new BranchDirection(Direction.DOWN, Direction.NORTH, null);
    public static final /* enum */ BranchDirection DOWN_NORTH_EAST = new BranchDirection(Direction.DOWN, Direction.NORTH, Direction.EAST);
    public static final /* enum */ BranchDirection DOWN_WEST = new BranchDirection(Direction.DOWN, null, Direction.WEST);
    public static final /* enum */ BranchDirection DOWN = new BranchDirection(Direction.DOWN, null, null);
    public static final /* enum */ BranchDirection DOWN_EAST = new BranchDirection(Direction.DOWN, null, Direction.EAST);
    public static final /* enum */ BranchDirection DOWN_SOUTH_WEST = new BranchDirection(Direction.DOWN, Direction.SOUTH, Direction.WEST);
    public static final /* enum */ BranchDirection DOWN_SOUTH = new BranchDirection(Direction.DOWN, Direction.SOUTH, null);
    public static final /* enum */ BranchDirection DOWN_SOUTH_EAST = new BranchDirection(Direction.DOWN, Direction.SOUTH, Direction.EAST);
    public static final /* enum */ BranchDirection UP_NORTH_WEST = new BranchDirection(Direction.UP, Direction.NORTH, Direction.WEST);
    public static final /* enum */ BranchDirection UP_NORTH = new BranchDirection(Direction.UP, Direction.NORTH, null);
    public static final /* enum */ BranchDirection UP_NORTH_EAST = new BranchDirection(Direction.UP, Direction.NORTH, Direction.EAST);
    public static final /* enum */ BranchDirection UP_WEST = new BranchDirection(Direction.UP, null, Direction.WEST);
    public static final /* enum */ BranchDirection UP = new BranchDirection(Direction.UP, null, null);
    public static final /* enum */ BranchDirection UP_EAST = new BranchDirection(Direction.UP, null, Direction.EAST);
    public static final /* enum */ BranchDirection UP_SOUTH_WEST = new BranchDirection(Direction.UP, Direction.SOUTH, Direction.WEST);
    public static final /* enum */ BranchDirection UP_SOUTH = new BranchDirection(Direction.UP, Direction.SOUTH, null);
    public static final /* enum */ BranchDirection UP_SOUTH_EAST = new BranchDirection(Direction.UP, Direction.SOUTH, Direction.EAST);
    public static final /* enum */ BranchDirection TRUNK_NORTH_WEST = new BranchDirection(Direction.DOWN, Direction.NORTH, Direction.WEST, true);
    public static final /* enum */ BranchDirection TRUNK_NORTH_EAST = new BranchDirection(Direction.DOWN, Direction.NORTH, Direction.EAST, true);
    public static final /* enum */ BranchDirection TRUNK_SOUTH_WEST = new BranchDirection(Direction.DOWN, Direction.SOUTH, Direction.WEST, true);
    public static final /* enum */ BranchDirection TRUNK_SOUTH_EAST = new BranchDirection(Direction.DOWN, Direction.SOUTH, Direction.EAST, true);
    private static final BranchDirection[] MIRROR;
    private static final BranchDirection[] ROTATE;
    private final int dx;
    private final int dy;
    private final int dz;
    private final boolean trunk;
    private final String serializedName;
    private static final /* synthetic */ BranchDirection[] $VALUES;

    public static BranchDirection[] values() {
        return (BranchDirection[])$VALUES.clone();
    }

    public static BranchDirection valueOf(String name) {
        return Enum.valueOf(BranchDirection.class, name);
    }

    private BranchDirection() {
        this(null, null, null);
    }

    private BranchDirection(Direction dz, Direction dx) {
        this(null, dz, dx);
    }

    private BranchDirection(@Nullable Direction dy, Direction dz, Direction dx) {
        this(dy, dz, dx, false);
    }

    private BranchDirection(@Nullable Direction dy, Direction dz, Direction dx, boolean trunk) {
        assert (dx == null || dx.m_122434_() == Direction.Axis.X);
        assert (dy == null || dy.m_122434_() == Direction.Axis.Y);
        assert (dz == null || dz.m_122434_() == Direction.Axis.Z);
        assert (!trunk || dx != null && dy != null && dz != null);
        this.dx = dx == null ? 0 : dx.m_122429_();
        this.dy = dy == null ? 0 : dy.m_122430_();
        this.dz = dz == null ? 0 : dz.m_122431_();
        this.trunk = trunk;
        this.serializedName = this.name().toLowerCase(Locale.ROOT);
    }

    public int dx() {
        return this.dx;
    }

    public int dy() {
        return this.dy;
    }

    public int dz() {
        return this.dz;
    }

    public BranchDirection rotate(Rotation rotation) {
        return switch (rotation) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE -> this;
            case Rotation.CLOCKWISE_90 -> this.rotate();
            case Rotation.CLOCKWISE_180 -> this.rotate().rotate();
            case Rotation.COUNTERCLOCKWISE_90 -> this.rotate().rotate().rotate();
        };
    }

    public BranchDirection mirror(Mirror mirror) {
        return switch (mirror) {
            default -> throw new IncompatibleClassChangeError();
            case Mirror.NONE -> this;
            case Mirror.LEFT_RIGHT -> this.mirror().rotate().rotate();
            case Mirror.FRONT_BACK -> this.mirror();
        };
    }

    private BranchDirection rotate() {
        return ROTATE[this.ordinal()];
    }

    private BranchDirection mirror() {
        return MIRROR[this.ordinal()];
    }

    public boolean trunk() {
        return this.trunk;
    }

    public boolean natural() {
        return this != NONE;
    }

    public boolean connected(BlockPos root, BlockPos branch) {
        if (this == NONE) {
            return false;
        }
        if (this.trunk) {
            return branch.m_7918_(this.dx, 0, 0).equals((Object)root) || branch.m_7918_(0, this.dy, 0).equals((Object)root) || branch.m_7918_(0, 0, this.dz).equals((Object)root);
        }
        return branch.m_7918_(this.dx, this.dy, this.dz).equals((Object)root);
    }

    public String m_7912_() {
        return this.serializedName;
    }

    private static /* synthetic */ BranchDirection[] $values() {
        return new BranchDirection[]{NONE, NORTH_WEST, NORTH, NORTH_EAST, WEST, EAST, SOUTH_WEST, SOUTH, SOUTH_EAST, DOWN_NORTH_WEST, DOWN_NORTH, DOWN_NORTH_EAST, DOWN_WEST, DOWN, DOWN_EAST, DOWN_SOUTH_WEST, DOWN_SOUTH, DOWN_SOUTH_EAST, UP_NORTH_WEST, UP_NORTH, UP_NORTH_EAST, UP_WEST, UP, UP_EAST, UP_SOUTH_WEST, UP_SOUTH, UP_SOUTH_EAST, TRUNK_NORTH_WEST, TRUNK_NORTH_EAST, TRUNK_SOUTH_WEST, TRUNK_SOUTH_EAST};
    }

    static {
        $VALUES = BranchDirection.$values();
        MIRROR = new BranchDirection[]{NONE, NORTH_EAST, NORTH, NORTH_WEST, EAST, WEST, SOUTH_EAST, SOUTH, SOUTH_WEST, DOWN_NORTH_EAST, DOWN_NORTH, DOWN_NORTH_WEST, DOWN_EAST, DOWN, DOWN_WEST, DOWN_SOUTH_EAST, DOWN_SOUTH, DOWN_SOUTH_WEST, UP_NORTH_EAST, UP_NORTH, UP_NORTH_WEST, UP_EAST, UP, UP_WEST, UP_SOUTH_EAST, UP_SOUTH, UP_SOUTH_WEST, TRUNK_NORTH_EAST, TRUNK_NORTH_WEST, TRUNK_SOUTH_EAST, TRUNK_SOUTH_WEST};
        ROTATE = new BranchDirection[]{NONE, NORTH_EAST, EAST, SOUTH_EAST, NORTH, SOUTH, NORTH_WEST, WEST, SOUTH_WEST, DOWN_NORTH_EAST, DOWN_EAST, DOWN_SOUTH_EAST, DOWN_NORTH, DOWN, DOWN_SOUTH, DOWN_NORTH_WEST, DOWN_WEST, DOWN_SOUTH_WEST, UP_NORTH_EAST, UP_EAST, UP_SOUTH_EAST, UP_NORTH, UP, UP_SOUTH, UP_NORTH_WEST, UP_WEST, UP_SOUTH_WEST, TRUNK_NORTH_EAST, TRUNK_SOUTH_EAST, TRUNK_NORTH_WEST, TRUNK_SOUTH_WEST};
    }
}

