/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.soil;

import java.awt.Color;
import net.dries007.tfc.common.blocks.soil.TFCSandBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;

public enum SandBlockType {
    BROWN(new Color(112, 113, 89).getRGB(), MapColor.f_283762_),
    WHITE(new Color(202, 202, 201).getRGB(), MapColor.f_283942_),
    BLACK(new Color(56, 56, 56).getRGB(), MapColor.f_283771_),
    RED(new Color(125, 99, 84).getRGB(), MapColor.f_283798_),
    YELLOW(new Color(215, 196, 140).getRGB(), MapColor.f_283761_),
    GREEN(new Color(106, 116, 81).getRGB(), MapColor.f_283784_),
    PINK(new Color(150, 101, 97).getRGB(), MapColor.f_283870_);

    private static final SandBlockType[] VALUES;
    private final int dustColor;
    private final MapColor mapColor;

    public static SandBlockType valueOf(int i) {
        return i >= 0 && i < VALUES.length ? VALUES[i] : BROWN;
    }

    private SandBlockType(int dustColor, MapColor materialColor) {
        this.dustColor = dustColor;
        this.mapColor = materialColor;
    }

    public int getDustColor() {
        return this.dustColor;
    }

    public MapColor getMaterialColor() {
        return this.mapColor;
    }

    public Block create() {
        return new TFCSandBlock(this.getDustColor(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_).m_284180_(this.getMaterialColor()).m_60978_(0.5f).m_60918_(SoundType.f_56746_));
    }

    static {
        VALUES = SandBlockType.values();
    }
}

