/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.soil;

import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.soil.IDirtBlock;
import net.dries007.tfc.common.blocks.soil.IMudBlock;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.registry.RegistrySoilVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class DirtBlock
extends Block
implements IDirtBlock,
IMudBlock {
    private final Supplier<? extends Block> grass;
    @Nullable
    private final Supplier<? extends Block> path;
    @Nullable
    private final Supplier<? extends Block> farmland;
    @Nullable
    private final Supplier<? extends Block> rooted;
    @Nullable
    private final Supplier<? extends Block> mud;

    public static boolean emptyBlockAbove(UseOnContext context) {
        return context.m_43719_() != Direction.DOWN && FluidHelpers.isAirOrEmptyFluid(context.m_43725_().m_8055_(context.m_8083_().m_7494_()));
    }

    public DirtBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> grass, @Nullable Supplier<? extends Block> path, @Nullable Supplier<? extends Block> farmland, @Nullable Supplier<? extends Block> rooted, @Nullable Supplier<? extends Block> mud) {
        super(properties);
        this.grass = grass;
        this.path = path;
        this.farmland = farmland;
        this.rooted = rooted;
        this.mud = mud;
    }

    DirtBlock(BlockBehaviour.Properties properties, SoilBlockType grassType, RegistrySoilVariant variant) {
        this(properties, variant.getBlock(grassType), variant.getBlock(SoilBlockType.GRASS_PATH), variant.getBlock(SoilBlockType.FARMLAND), variant.getBlock(SoilBlockType.ROOTED_DIRT), variant.getBlock(SoilBlockType.MUD));
    }

    @Override
    public BlockState getGrass() {
        return this.grass.get().m_49966_();
    }

    public BlockState getRooted() {
        return this.rooted.get().m_49966_();
    }

    @Override
    public BlockState getMud() {
        return this.mud.get().m_49966_();
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction action, boolean simulate) {
        if (context.m_43722_().canPerformAction(action)) {
            if (action == ToolActions.SHOVEL_FLATTEN && this.path != null && ((Boolean)TFCConfig.SERVER.enableGrassPathCreation.get()).booleanValue()) {
                return this.path.get().m_49966_();
            }
            if (action == ToolActions.HOE_TILL && this.farmland != null && ((Boolean)TFCConfig.SERVER.enableFarmlandCreation.get()).booleanValue() && DirtBlock.emptyBlockAbove(context)) {
                return this.farmland.get().m_49966_();
            }
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.mud != null) {
            return this.transformToMud(this.mud.get().m_49966_(), level, pos, player, hand);
        }
        return InteractionResult.PASS;
    }
}

