/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rotation;

import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FluidPipeBlock
extends ExtendedBlock
implements DirectionPropertyBlock,
IFluidLoggable {
    public static final FluidProperty FLUID = TFCBlockStateProperties.ALL_WATER;
    private static final VoxelShape[] SHAPES = new VoxelShape[64];

    public FluidPipeBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_(DirectionPropertyBlock.setAllDirections((BlockState)this.m_49965_().m_61090_(), false));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return this.updateConnectedSides(level, currentPos, state, null);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        BlockState state = this.updateConnectedSides((LevelAccessor)context.m_43725_(), context.m_8083_(), this.m_49966_(), context.m_7820_());
        if (this.getFluidProperty().canContain(fluidState.m_76152_())) {
            return (BlockState)state.m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluidState.m_76152_()));
        }
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int index = 0;
        for (Direction side : Helpers.DIRECTIONS) {
            if (!((Boolean)state.m_61143_((Property)DirectionPropertyBlock.getProperty(side))).booleanValue()) continue;
            index |= 1 << side.ordinal();
        }
        return SHAPES[index];
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_((Property[])PROPERTIES).m_61104_(new Property[]{this.getFluidProperty()});
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidLoggedState(state);
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return DirectionPropertyBlock.rotate(state, rotation);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return DirectionPropertyBlock.mirror(state, mirror);
    }

    private BlockState updateConnectedSides(LevelAccessor level, BlockPos pos, BlockState state, @Nullable Direction defaultDirection) {
        int openSides = 0;
        Direction openDirection = null;
        for (Direction direction : Helpers.DIRECTIONS) {
            BlockPos adjacentPos;
            BlockState adjacentState;
            boolean adjacentConnection;
            BooleanProperty property = DirectionPropertyBlock.getProperty(direction);
            if (defaultDirection == null && ((Boolean)state.m_61143_((Property)property)).booleanValue()) {
                defaultDirection = direction;
            }
            if (adjacentConnection = this.connectsToPipeInDirection(adjacentState = level.m_8055_(adjacentPos = pos.m_121945_(direction)), direction)) {
                ++openSides;
                openDirection = direction;
            }
            state = (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(adjacentConnection));
        }
        if (openSides == 0) {
            assert (defaultDirection != null);
            return (BlockState)((BlockState)state.m_61124_((Property)DirectionPropertyBlock.getProperty(defaultDirection), (Comparable)Boolean.valueOf(true))).m_61124_((Property)DirectionPropertyBlock.getProperty(defaultDirection.m_122424_()), (Comparable)Boolean.valueOf(true));
        }
        if (openSides == 1) {
            return (BlockState)state.m_61124_((Property)DirectionPropertyBlock.getProperty(openDirection.m_122424_()), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    private boolean connectsToPipeInDirection(BlockState state, Direction direction) {
        return state.m_60734_() == this || state.m_60734_() == TFCBlocks.STEEL_PUMP.get() && direction == Direction.UP;
    }

    static {
        VoxelShape north = FluidPipeBlock.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0);
        VoxelShape south = FluidPipeBlock.m_49796_((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)16.0);
        VoxelShape west = FluidPipeBlock.m_49796_((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
        VoxelShape east = FluidPipeBlock.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0);
        VoxelShape up = FluidPipeBlock.m_49796_((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
        VoxelShape down = FluidPipeBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0);
        VoxelShape[] directions = new VoxelShape[]{down, up, north, south, east, west};
        VoxelShape center = FluidPipeBlock.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
        for (int i = 0; i < SHAPES.length; ++i) {
            VoxelShape shape = center;
            for (Direction direction : Helpers.DIRECTIONS) {
                if ((i >> direction.ordinal() & 1) != 1) continue;
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)directions[direction.ordinal()]);
            }
            FluidPipeBlock.SHAPES[i] = shape;
        }
    }
}

