/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rotation;

import java.util.Locale;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrankshaftBlock
extends HorizontalDirectionalBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<Part> PART = TFCBlockStateProperties.CRANKSHAFT_PART;
    private static final VoxelShape[] BASE_SHAPES = Helpers.computeHorizontalShapes(dir -> Shapes.m_83110_((VoxelShape)Helpers.rotateShape(dir, 0.0, 0.0, 4.0, 16.0, 2.0, 12.0), (VoxelShape)Helpers.rotateShape(dir, 0.0, 2.0, 4.0, 4.0, 12.0, 12.0)));
    private static final VoxelShape[] SHAFT_SHAPES = Helpers.computeHorizontalShapes(dir -> Helpers.rotateShape(dir, 0.0, 7.0, 8.0, 16.0, 9.0, 10.0));
    private static final TagKey<Item> STEEL_RODS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Helpers.resourceLocation("forge", "rods/steel"));
    private final ExtendedProperties properties;

    public CrankshaftBlock(ExtendedProperties properties) {
        super(properties.properties());
        this.properties = properties;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(FACING, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)Part.BASE)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockPos partnerPos;
        BlockState stateAt;
        ItemStack held = player.m_21120_(hand);
        if (state.m_61143_(PART) == Part.BASE && Helpers.isItem(held.m_41720_(), STEEL_RODS) && (stateAt = level.m_8055_(partnerPos = this.getPartnerPos(pos, state))).m_247087_() && stateAt.m_60819_().m_76178_()) {
            level.m_46597_(partnerPos, (BlockState)state.m_61124_(PART, (Comparable)((Object)Part.SHAFT)));
            if (!player.m_7500_()) {
                held.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_8125_().m_122427_());
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (state.m_61143_(PART) == Part.SHAFT && facingPos.equals((Object)this.getPartnerPos(currentPos, state))) {
            return facingState.m_60734_() == this && facingState.m_61143_(FACING) == state.m_61143_(FACING) ? state : Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int index = ((Direction)state.m_61143_(FACING)).m_122416_();
        return state.m_61143_(PART) == Part.BASE ? BASE_SHAPES[index] : SHAFT_SHAPES[(index + 3) % 4];
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PART});
    }

    private BlockPos getPartnerPos(BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_(FACING);
        return state.m_61143_(PART) == Part.BASE ? pos.m_121945_(facing) : pos.m_121945_(facing.m_122424_());
    }

    public static enum Part implements StringRepresentable
    {
        BASE,
        SHAFT;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

