/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rotation;

import net.dries007.tfc.common.blockentities.rotation.RotatingBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.rotation.ConnectedAxleBlock;
import net.dries007.tfc.common.blocks.wood.ExtendedRotatedPillarBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractShaftAxleBlock
extends ExtendedRotatedPillarBlock
implements IFluidLoggable,
EntityBlockExtension,
ConnectedAxleBlock {
    public static final FluidProperty FLUID = TFCBlockStateProperties.WATER;
    public static final VoxelShape SHAPE_Z = AbstractShaftAxleBlock.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);
    public static final VoxelShape SHAPE_X = AbstractShaftAxleBlock.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    public static final VoxelShape SHAPE_Y = AbstractShaftAxleBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private final ExtendedProperties properties;

    public AbstractShaftAxleBlock(ExtendedProperties properties) {
        super(properties);
        this.properties = properties;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_55923_, (Comparable)Direction.Axis.X)).m_61124_((Property)FLUID, (Comparable)FLUID.keyFor(Fluids.f_76191_)));
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof RotatingBlockEntity) {
            RotatingBlockEntity entity = (RotatingBlockEntity)blockEntity;
            entity.destroyIfInvalid((Level)level, pos);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.m_61143_((Property)f_55923_)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> SHAPE_X;
            case Direction.Axis.Y -> SHAPE_Y;
            case Direction.Axis.Z -> SHAPE_Z;
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        if (state != null && !fluidState.m_76178_()) {
            return (BlockState)state.m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyForOrEmpty(fluidState.m_76152_()));
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{this.getFluidProperty()}));
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidLoggedState(state);
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }
}

