/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rock;

import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.rock.RawRockBlock;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.dries007.tfc.util.registry.RegistryRock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class RockConvertableToAnvilBlock
extends RawRockBlock {
    private final Supplier<? extends Block> anvil;

    public static Block createForIgneousOnly(BlockBehaviour.Properties properties, RegistryRock rock, boolean naturallySupported) {
        return rock.category() == RockCategory.IGNEOUS_EXTRUSIVE || rock.category() == RockCategory.IGNEOUS_INTRUSIVE ? new RockConvertableToAnvilBlock(properties, rock.getAnvil(), naturallySupported, rock.displayCategory().createTooltip()) : new RawRockBlock(properties, naturallySupported, rock.displayCategory().createTooltip());
    }

    public RockConvertableToAnvilBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> anvil, boolean naturallySupported, @Nullable Component rockTypeTooltip) {
        super(properties, naturallySupported, rockTypeTooltip);
        this.anvil = anvil;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (Helpers.isItem(stack, TFCTags.Items.HAMMERS) && !Helpers.isItem(player.m_21120_(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND), TFCTags.Items.CHISELS) && hit.m_82434_() == Direction.UP && level.m_8055_(pos.m_7494_()).m_60795_()) {
            BlockState block = this.anvil.get().m_49966_();
            level.m_46597_(pos, block);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                TFCAdvancements.ROCK_ANVIL.trigger(serverPlayer, block);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

