/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.plant.PlantBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public abstract class WaterPlantBlock
extends PlantBlock
implements IFluidLoggable {
    public static WaterPlantBlock create(final RegistryPlant plant, final FluidProperty fluid, BlockBehaviour.Properties properties) {
        return new WaterPlantBlock(ExtendedProperties.of(properties)){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }

            @Override
            public FluidProperty getFluidProperty() {
                return fluid;
            }
        };
    }

    protected WaterPlantBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(Fluids.f_76191_)));
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(pos);
        BlockState state = this.updateStateWithCurrentMonth(this.m_49966_());
        if (this.getFluidProperty().canContain(fluidState.m_76152_())) {
            state = (BlockState)state.m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluidState.m_76152_()));
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{this.getFluidProperty()});
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState belowState = level.m_8055_(pos.m_7495_());
        return Helpers.isBlock(belowState, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON) && state.m_61143_((Property)this.getFluidProperty()) != this.getFluidProperty().keyFor(Fluids.f_76191_);
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidLoggedState(state);
    }
}

