/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.HashSet;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.BranchingCactusBlock;
import net.dries007.tfc.common.blocks.plant.PlantBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class GrowingBranchingCactusBlock
extends BranchingCactusBlock {
    public static final BooleanProperty GROWS_BRANCHES = TFCBlockStateProperties.GROWS_BRANCHES;
    private final Supplier<? extends Block> body;
    private final Supplier<? extends Block> flower;

    public static GrowingBranchingCactusBlock createGrowing(ExtendedProperties properties, Supplier<? extends Block> body, Supplier<? extends Block> flower) {
        return new GrowingBranchingCactusBlock(0.3125f, properties, body, flower);
    }

    public GrowingBranchingCactusBlock(float size, ExtendedProperties properties, Supplier<? extends Block> body, Supplier<? extends Block> flower) {
        super(size, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)GROWS_BRANCHES, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_55148_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55149_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55150_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55151_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55152_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55153_, (Comparable)Boolean.valueOf(false)));
        this.flower = flower;
        this.body = body;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{GROWS_BRANCHES}));
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if ((double)rand.m_188501_() > (Double)TFCConfig.SERVER.plantGrowthChance.get()) {
            this.growthTick((LevelAccessor)level, pos, state);
        }
    }

    public void growthTick(LevelAccessor level, BlockPos pos, BlockState state) {
        boolean willBranch;
        if (level.m_8055_(pos.m_7494_()).m_60734_() instanceof BranchingCactusBlock) {
            level.m_7731_(pos, Helpers.copyProperties(this.body.get().m_49966_(), state), 3);
            return;
        }
        if (((Boolean)state.m_61143_((Property)GROWS_BRANCHES)).booleanValue() || level.m_213780_().m_188501_() < 0.1f) {
            if (level.m_8055_(pos.m_6625_(7)).m_60734_() instanceof BranchingCactusBlock) {
                level.m_7731_(pos, Helpers.copyProperties(this.body.get().m_49966_(), state), 3);
                this.tryFruit(level, pos.m_7494_());
                return;
            }
        } else if (level.m_8055_(pos.m_6625_(3)).m_60734_() instanceof BranchingCactusBlock || level.m_213780_().m_188501_() < 0.5f) {
            level.m_7731_(pos, Helpers.copyProperties(this.body.get().m_49966_(), state), 3);
            this.tryFruit(level, pos.m_7494_());
            return;
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        RandomSource random = level.m_213780_();
        Direction dir = Direction.Plane.HORIZONTAL.m_235690_(random);
        BlockState body = this.body.get().m_49966_();
        BranchingCactusBlock bodyBlock = (BranchingCactusBlock)body.m_60734_();
        boolean bl = willBranch = random.m_188501_() < 0.7f && (Boolean)state.m_61143_((Property)GROWS_BRANCHES) != false;
        if (willBranch) {
            willBranch = GrowingBranchingCactusBlock.ensureNeighborhoodForBranch(level, pos, cursor, dir, willBranch);
        }
        cursor.m_122154_((Vec3i)pos, 0, 1, 0);
        level.m_7731_((BlockPos)cursor, (BlockState)this.getStateForPlacement((BlockGetter)level, (BlockPos)cursor).m_61124_((Property)GROWS_BRANCHES, (Comparable)((Boolean)state.m_61143_((Property)GROWS_BRANCHES))), 3);
        cursor.m_122184_(0, -1, 0);
        BlockState below = level.m_8055_((BlockPos)cursor);
        if (below.m_60734_() == this) {
            level.m_7731_((BlockPos)cursor, Helpers.copyProperties(body, below), 3);
        }
        cursor.m_122184_(0, 1, 0);
        if (willBranch && this.canGrowInto(level, (BlockPos)cursor.m_122173_(dir), dir) && this.canGrowInto(level, (BlockPos)cursor.m_122173_(dir), dir) && this.canGrowInto(level, (BlockPos)cursor.m_122184_(0, 1, 0), Direction.UP)) {
            cursor.m_122159_((Vec3i)pos, dir);
            level.m_7731_((BlockPos)cursor, bodyBlock.getStateForPlacement((BlockGetter)level, (BlockPos)cursor), 3);
            cursor.m_122173_(dir);
            level.m_7731_((BlockPos)cursor, (BlockState)((BlockState)this.getStateForPlacement((BlockGetter)level, (BlockPos)cursor).m_61124_((Property)GROWS_BRANCHES, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55152_, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private static boolean ensureNeighborhoodForBranch(LevelAccessor level, BlockPos pos, BlockPos.MutableBlockPos cursor, Direction dir, boolean willBranch) {
        int i;
        cursor.m_122184_(0, -1, 0);
        if (!(level.m_8055_((BlockPos)cursor).m_60734_() instanceof BranchingCactusBlock)) {
            willBranch = false;
        }
        cursor.m_122159_((Vec3i)pos, dir);
        for (i = 0; i < 2; ++i) {
            cursor.m_122184_(0, -1, 0);
            if (!(level.m_8055_((BlockPos)cursor).m_60734_() instanceof BranchingCactusBlock)) continue;
            willBranch = false;
        }
        cursor.m_122159_((Vec3i)pos, dir);
        for (i = 0; i < 3; ++i) {
            cursor.m_122184_(0, 1, 0);
            if (!(level.m_8055_((BlockPos)cursor).m_60734_() instanceof BranchingCactusBlock)) continue;
            willBranch = false;
        }
        return willBranch;
    }

    public boolean growRecursively(LevelAccessor level, BlockPos pos, BlockState state, int height) {
        BlockState body = this.body.get().m_49966_();
        BranchingCactusBlock bodyBlock = (BranchingCactusBlock)body.m_60734_();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        RandomSource random = level.m_213780_();
        cursor.m_122184_(0, -1, 0);
        if (!(this.testDown(state) && this.canGrowInto(level, pos, Direction.UP) && this.canGrowInto(level, pos.m_7494_(), Direction.UP))) {
            return false;
        }
        HashSet<Direction> usedDirections = new HashSet<Direction>();
        for (int i = 0; i < height; ++i) {
            Direction dir;
            BlockState placeState = (BlockState)((BlockState)body.m_61124_((Property)f_55153_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_55152_, (Comparable)Boolean.valueOf(true));
            cursor.m_122154_((Vec3i)pos, 0, i, 0);
            if (i == height - 1) {
                cursor.m_122184_(0, 1, 0);
                this.tryFruit(level, (BlockPos)cursor);
                cursor.m_122184_(0, -1, 0);
            }
            if (!this.canGrowInto(level, (BlockPos)cursor, Direction.UP)) {
                return true;
            }
            if (i == height - 1) {
                placeState = Helpers.copyProperties(body, placeState);
            }
            level.m_7731_((BlockPos)cursor, placeState, 3);
            if (!((Boolean)state.m_61143_((Property)GROWS_BRANCHES)).booleanValue() || i <= 2 || !(random.m_188501_() < 0.6f) || i >= height - 1 || usedDirections.contains(dir = Direction.Plane.HORIZONTAL.m_235690_(random)) || !this.canGrowInto(level, (BlockPos)cursor.m_122173_(dir), dir) || !this.canGrowInto(level, (BlockPos)cursor.m_122173_(dir), dir) || !this.canGrowInto(level, (BlockPos)cursor.m_122184_(0, 1, 0), Direction.UP)) continue;
            usedDirections.add(dir);
            cursor.m_122159_((Vec3i)pos, dir).m_122184_(0, i, 0);
            level.m_7731_((BlockPos)cursor, (BlockState)((BlockState)body.m_61124_((Property)f_55154_.get(dir), (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_55154_.get(dir.m_122424_()), (Comparable)Boolean.valueOf(true)), 3);
            cursor.m_122173_(dir);
            BlockState newState = (BlockState)((BlockState)((BlockState)state.m_61124_((Property)GROWS_BRANCHES, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55154_.get(dir.m_122424_()), (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_55152_, (Comparable)Boolean.valueOf(true));
            level.m_7731_((BlockPos)cursor, newState, 3);
            cursor.m_122184_(0, 1, 0);
            this.growRecursively(level, cursor.m_7949_(), newState, 3);
            cursor.m_122154_((Vec3i)pos, 0, i, 0);
            level.m_7731_((BlockPos)cursor, (BlockState)placeState.m_61124_((Property)f_55154_.get(dir), (Comparable)Boolean.valueOf(true)), 3);
        }
        return true;
    }

    public boolean canGrowInto(LevelAccessor level, BlockPos pos, Direction direction) {
        if (!level.m_8055_(pos).m_60795_()) {
            return false;
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (Direction dir : Helpers.DIRECTIONS) {
            cursor.m_122159_((Vec3i)pos, dir);
            if (!level.isAreaLoaded((BlockPos)cursor, 1) || dir == direction.m_122424_() || !this.testHorizontal(level.m_8055_((BlockPos)cursor))) continue;
            return false;
        }
        return true;
    }

    private void tryFruit(LevelAccessor level, BlockPos pos) {
        if (level.m_8055_(pos).m_247087_()) {
            PlantBlock plant = (PlantBlock)this.flower.get();
            level.m_7731_(pos, plant.updateStateWithCurrentMonth(plant.m_49966_()), 3);
        }
    }

    @Override
    protected boolean canGrowLongSideways() {
        return true;
    }
}

