/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.plant.PlantBlock;
import net.dries007.tfc.common.blocks.plant.PlantRegrowth;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class CreepingPlantBlock
extends PlantBlock
implements DirectionPropertyBlock {
    protected static final VoxelShape UP_SHAPE = CreepingPlantBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape DOWN_SHAPE = CreepingPlantBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = CreepingPlantBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape EAST_SHAPE = CreepingPlantBlock.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = CreepingPlantBlock.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE = CreepingPlantBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final Map<BooleanProperty, VoxelShape> SHAPES = ImmutableMap.builder().put((Object)UP, (Object)UP_SHAPE).put((Object)DOWN, (Object)DOWN_SHAPE).put((Object)NORTH, (Object)NORTH_SHAPE).put((Object)SOUTH, (Object)SOUTH_SHAPE).put((Object)EAST, (Object)EAST_SHAPE).put((Object)WEST, (Object)WEST_SHAPE).build();
    protected final Map<BlockState, VoxelShape> shapeCache;

    public static CreepingPlantBlock create(final RegistryPlant plant, ExtendedProperties properties) {
        return new CreepingPlantBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }
        };
    }

    public static CreepingPlantBlock createStone(final RegistryPlant plant, ExtendedProperties properties) {
        return new CreepingPlantBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }

            @Override
            public boolean canCreepOn(LevelReader level, BlockPos pos, BlockState state, Direction direction) {
                return Helpers.isBlock(state, TFCTags.Blocks.CREEPING_STONE_PLANTABLE_ON) && super.canCreepOn(level, pos, state, direction);
            }
        };
    }

    protected CreepingPlantBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_(DirectionPropertyBlock.setAllDirections((BlockState)this.m_49965_().m_61090_(), false));
        this.shapeCache = DirectionPropertyBlock.makeShapeCache((StateDefinition<Block, BlockState>)this.m_49965_(), SHAPES::get);
    }

    @Override
    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213898_(state, level, pos, random);
        if (PlantRegrowth.canSpread((Level)level, random)) {
            BlockState newState;
            BlockPos newPos;
            Direction direction = Direction.m_235672_((RandomSource)random);
            if (direction == Direction.DOWN) {
                direction = Direction.UP;
            }
            BlockPos blockPos = newPos = random.m_188501_() < 0.2f ? pos.m_121945_(direction).m_7494_() : pos.m_121945_(direction);
            if (level.m_8055_(newPos).m_60795_() && !(newState = CreepingPlantBlock.updateStateFromSides((LevelAccessor)level, newPos, state)).m_60795_()) {
                level.m_46597_(newPos, newState);
            }
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return this.isEmpty(state = (BlockState)state.m_61124_((Property)PipeBlock.f_55154_.get(direction), (Comparable)Boolean.valueOf(this.canCreepOn((LevelReader)level, facingPos, facingState, direction)))) ? Blocks.f_50016_.m_49966_() : state;
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction direction : f_60441_) {
            mutablePos.m_122159_((Vec3i)pos, direction);
            if (!this.canCreepOn(level, (BlockPos)mutablePos, level.m_8055_((BlockPos)mutablePos), direction)) continue;
            return true;
        }
        return false;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, false);
        }
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeCache.get(state);
    }

    @Override
    @NotNull
    public BlockState m_5573_(BlockPlaceContext context) {
        return CreepingPlantBlock.updateStateFromSides((LevelAccessor)context.m_43725_(), context.m_8083_(), this.updateStateWithCurrentMonth(this.m_49966_()));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST}));
    }

    public static BlockState updateStateFromSides(LevelAccessor level, BlockPos pos, BlockState state) {
        CreepingPlantBlock block = (CreepingPlantBlock)state.m_60734_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        boolean hasEarth = false;
        for (Direction direction : f_60441_) {
            mutablePos.m_122159_((Vec3i)pos, direction);
            boolean ground = block.canCreepOn((LevelReader)level, pos, level.m_8055_((BlockPos)mutablePos), direction);
            state = (BlockState)state.m_61124_((Property)PipeBlock.f_55154_.get(direction), (Comparable)Boolean.valueOf(ground));
            hasEarth |= ground;
        }
        return hasEarth ? state : Blocks.f_50016_.m_49966_();
    }

    private boolean isEmpty(BlockState state) {
        for (BooleanProperty property : SHAPES.keySet()) {
            if (!((Boolean)state.m_61143_((Property)property)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return DirectionPropertyBlock.rotate(state, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return DirectionPropertyBlock.mirror(state, mirror);
    }

    public boolean canCreepOn(LevelReader level, BlockPos pos, BlockState state, Direction direction) {
        return state.m_60783_((BlockGetter)level, pos, direction.m_122424_());
    }
}

