/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SluiceBlock
extends DeviceBlock
implements EntityBlockExtension {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty UPPER = TFCBlockStateProperties.UPPER;
    private static final VoxelShape[] TOP_SHAPES = Helpers.computeHorizontalShapes(SluiceBlock::createTopShape);
    private static final VoxelShape[] BOTTOM_SHAPES = Helpers.computeHorizontalShapes(SluiceBlock::createBottomShape);

    public static BlockPos getFluidOutputPos(BlockState state, BlockPos pos) {
        return pos.m_5484_((Direction)state.m_61143_((Property)FACING), 2).m_7495_();
    }

    private static VoxelShape createTopShape(Direction direction) {
        return Shapes.m_83124_((VoxelShape)Helpers.rotateShape(direction, 0.0, 0.0, 0.0, 16.0, 10.0, 1.0), (VoxelShape[])new VoxelShape[]{Helpers.rotateShape(direction, 0.0, 0.0, 1.0, 16.0, 9.0, 4.0), Helpers.rotateShape(direction, 0.0, 0.0, 4.0, 16.0, 12.0, 5.0), Helpers.rotateShape(direction, 0.0, 0.0, 5.0, 16.0, 11.0, 8.0), Helpers.rotateShape(direction, 0.0, 0.0, 8.0, 16.0, 14.0, 9.0), Helpers.rotateShape(direction, 0.0, 0.0, 9.0, 16.0, 13.0, 12.0), Helpers.rotateShape(direction, 0.0, 0.0, 12.0, 16.0, 16.0, 13.0), Helpers.rotateShape(direction, 0.0, 0.0, 13.0, 16.0, 15.0, 16.0)});
    }

    private static VoxelShape createBottomShape(Direction direction) {
        return Shapes.m_83124_((VoxelShape)Helpers.rotateShape(direction, 0.0, 0.0, 0.0, 16.0, 2.0, 1.0), (VoxelShape[])new VoxelShape[]{Helpers.rotateShape(direction, 0.0, 0.0, 1.0, 16.0, 1.0, 4.0), Helpers.rotateShape(direction, 0.0, 0.0, 4.0, 16.0, 4.0, 5.0), Helpers.rotateShape(direction, 0.0, 0.0, 5.0, 16.0, 3.0, 8.0), Helpers.rotateShape(direction, 0.0, 0.0, 8.0, 16.0, 6.0, 9.0), Helpers.rotateShape(direction, 0.0, 0.0, 9.0, 16.0, 5.0, 12.0), Helpers.rotateShape(direction, 0.0, 0.0, 12.0, 16.0, 8.0, 13.0), Helpers.rotateShape(direction, 0.0, 0.0, 13.0, 16.0, 7.0, 16.0)});
    }

    public SluiceBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)UPPER, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{UPPER, FACING}));
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        level.m_46597_(pos.m_121945_((Direction)state.m_61143_((Property)FACING)), (BlockState)state.m_61124_((Property)UPPER, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Direction direction = context.m_8125_();
        Level level = context.m_43725_();
        if (level.m_8055_(pos).m_247087_() && level.m_8055_(pos.m_121945_(direction)).m_247087_()) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)UPPER, (Comparable)Boolean.valueOf(true));
        }
        return null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int idx = ((Direction)state.m_61143_((Property)FACING)).m_122416_();
        return (Boolean)state.m_61143_((Property)UPPER) != false ? TOP_SHAPES[idx] : BOTTOM_SHAPES[idx];
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (((Boolean)state.m_61143_((Property)UPPER)).booleanValue() && entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            item.m_20334_(0.0, 0.0, 0.0);
        }
        super.m_7892_(state, level, pos, entity);
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPos fluidPos;
        BlockState originalState;
        FluidState fluid;
        if (!level.f_46443_ && (Helpers.isFluid(fluid = (originalState = level.m_8055_(fluidPos = SluiceBlock.getFluidOutputPos(state, pos))).m_60819_(), TFCTags.Fluids.USABLE_IN_SLUICE) || FluidHelpers.isMeltableIce(originalState))) {
            BlockState resultState = FluidHelpers.emptyFluidFrom(originalState);
            level.m_46597_(fluidPos, resultState);
            if (!resultState.m_60795_()) {
                level.m_186460_(fluidPos, resultState.m_60734_(), 1);
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (!((Boolean)state.m_61143_((Property)UPPER)).booleanValue() && direction == facing.m_122424_() && !Helpers.isBlock(facingState, this)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)state.m_61143_((Property)UPPER)).booleanValue() && direction == facing && !Helpers.isBlock(facingState, this)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        BlockPos fluidPos;
        BlockState fluidState;
        BlockState state = level.m_8055_(pos);
        if (state.m_61138_((Property)FACING) && Helpers.isFluid((fluidState = level.m_8055_(fluidPos = SluiceBlock.getFluidOutputPos(state, pos))).m_60819_(), TFCTags.Fluids.USABLE_IN_SLUICE)) {
            level.m_46597_(fluidPos, FluidHelpers.emptyFluidFrom(fluidState));
        }
        super.m_7592_(level, pos, explosion);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

