/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCDamageSources;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.FirepitBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;

public class PotBlock
extends FirepitBlock {
    private static final VoxelShape POT_SHAPE = Shapes.m_83110_((VoxelShape)BASE_SHAPE, (VoxelShape)PotBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0));

    public PotBlock(ExtendedProperties properties) {
        super(properties, POT_SHAPE);
    }

    @Override
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.POT.get()).ifPresent(pot -> {
            if (!pot.shouldRenderAsBoiling()) {
                return;
            }
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            for (int i = 0; i < random.m_188503_(5) + 4; ++i) {
                level.m_6493_((ParticleOptions)TFCParticles.BUBBLE.get(), false, x + (double)random.m_188501_() * 0.375 - 0.1875, y + 0.625, z + (double)random.m_188501_() * 0.375 - 0.1875, 0.0, 0.05, 0.0);
            }
            level.m_6493_((ParticleOptions)TFCParticles.STEAM.get(), false, x, y + 0.8, z, (double)Helpers.triangle(random), 0.5, (double)Helpers.triangle(random));
            level.m_7785_(x, y, z, SoundEvents.f_12540_, SoundSource.BLOCKS, 1.0f, random.m_188501_() * 0.7f + 0.4f, false);
        });
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.POT.get()).map(pot -> {
            InteractionResult interactResult;
            ItemStack stack = player.m_21120_(hand);
            if (!pot.isBoiling() && stack.m_41619_() && player.m_6144_()) {
                if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                    TFCDamageSources.pot((Entity)player, 1.0f);
                    Helpers.playSound(level, pos, (SoundEvent)TFCSounds.ITEM_COOL.get());
                }
                if (!(((Boolean)state.m_61143_((Property)LIT)).booleanValue() || pot.isBoiling() || ((Boolean)state.m_61143_((Property)LIT)).booleanValue() || pot.getAsh() <= 0)) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)TFCItems.POWDERS.get((Object)Powder.WOOD_ASH).get(), pot.getAsh()));
                    pot.setAsh(0);
                    Helpers.playSound(level, pos, SoundEvents.f_12331_);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)TFCItems.POT.get()));
                AbstractFirepitBlockEntity.convertTo((LevelAccessor)level, pos, state, pot, (Block)TFCBlocks.FIREPIT.get());
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!pot.isBoiling() && FluidHelpers.transferBetweenBlockEntityAndItem(stack, pot, player, hand)) {
                pot.setAndUpdateSlots(-1);
                pot.markForSync();
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!pot.isBoiling() && (interactResult = pot.interactWithOutput(player, stack)) != InteractionResult.PASS) {
                return interactResult;
            }
            if (PotBlock.tryInsertLog(player, stack, pot, result.m_82450_().f_82480_ - (double)pos.m_123342_() < 0.6)) {
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Helpers.openScreen(serverPlayer, (MenuProvider)pot, pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }).orElse(InteractionResult.PASS);
    }

    @Override
    public double getParticleHeightOffset() {
        return 0.8;
    }
}

