/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.stream.Collectors;
import net.dries007.tfc.client.IHighlightHandler;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCDamageSources;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.GrillBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.FirepitBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class GrillBlock
extends FirepitBlock
implements IHighlightHandler {
    private static final Map<Integer, VoxelShape> SLOT_RENDER_SHAPES = Map.of(8, Shapes.m_83048_((double)0.4, (double)0.65, (double)0.4, (double)0.6, (double)0.7, (double)0.6), 7, Shapes.m_83048_((double)0.6, (double)0.6, (double)0.6, (double)0.8, (double)0.7, (double)0.8), 6, Shapes.m_83048_((double)0.6, (double)0.6, (double)0.2, (double)0.8, (double)0.7, (double)0.4), 5, Shapes.m_83048_((double)0.2, (double)0.6, (double)0.6, (double)0.4, (double)0.7, (double)0.8), 4, Shapes.m_83048_((double)0.2, (double)0.65, (double)0.2, (double)0.4, (double)0.7, (double)0.4));
    private static final Map<Integer, AABB> SLOT_BOUNDS = SLOT_RENDER_SHAPES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((VoxelShape)entry.getValue()).m_83215_().m_82400_((double)0.01f)));
    public static final Map<Integer, Vec3> SLOT_CENTERS = SLOT_BOUNDS.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((AABB)entry.getValue()).m_82399_().m_82542_(1.0, 0.0, 1.0).m_82520_(0.0, 0.625, 0.0)));
    private static final VoxelShape GRILL_SHAPE = Shapes.m_83110_((VoxelShape)BASE_SHAPE, (VoxelShape)GrillBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0));

    public static int getSlotForSelection(BlockHitResult result) {
        Vec3 location = result.m_82450_();
        BlockPos pos = result.m_82425_();
        for (Map.Entry<Integer, AABB> entry : SLOT_BOUNDS.entrySet()) {
            if (!entry.getValue().m_82338_(pos).m_82390_(location)) continue;
            return entry.getKey();
        }
        return -1;
    }

    public GrillBlock(ExtendedProperties properties) {
        super(properties, GRILL_SHAPE);
    }

    @Override
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        GrillBlockEntity grill;
        IItemHandler inv;
        BlockEntity blockEntity;
        super.m_214162_(state, level, pos, random);
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof GrillBlockEntity && (inv = Helpers.getCapability((ICapabilityProvider)(grill = (GrillBlockEntity)blockEntity), Capabilities.ITEM)) != null) {
            SLOT_CENTERS.forEach((slot, vec) -> {
                if (!inv.getStackInSlot(slot.intValue()).m_41619_() && random.m_188501_() < 0.4f) {
                    double x = vec.f_82479_ + (double)pos.m_123341_();
                    double y = vec.f_82480_ + (double)pos.m_123342_();
                    double z = vec.f_82481_ + (double)pos.m_123343_();
                    level.m_7785_(x, y, z, SoundEvents.f_11907_, SoundSource.BLOCKS, 0.25f, random.m_188501_() * 0.7f + 0.4f, false);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
                }
            });
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GrillBlockEntity) {
            ItemStack current;
            GrillBlockEntity grill = (GrillBlockEntity)blockEntity;
            ItemStack stack = player.m_21120_(hand);
            IItemHandler inv = Helpers.getCapability((ICapabilityProvider)grill, Capabilities.ITEM);
            int slot = GrillBlock.getSlotForSelection(result);
            ItemStack itemStack = current = slot == -1 || inv == null ? ItemStack.f_41583_ : inv.getStackInSlot(slot);
            if (!stack.m_41619_() && inv != null && slot != -1 && current.m_41619_() && inv.isItemValid(slot, stack)) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)inv.insertItem(slot, stack.m_41620_(1), false));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (stack.m_41619_() && slot != -1 && inv != null && !current.m_41619_() && (!inv.isItemValid(slot, current) || player.m_6144_())) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)inv.extractItem(slot, 64, false));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (stack.m_41619_() && player.m_6144_()) {
                if (!level.f_46443_) {
                    if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                        TFCDamageSources.grill((Entity)player, 1.0f);
                        Helpers.playSound(level, pos, (SoundEvent)TFCSounds.ITEM_COOL.get());
                    }
                    if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !((Boolean)state.m_61143_((Property)LIT)).booleanValue() && grill.getAsh() > 0) {
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)TFCItems.POWDERS.get((Object)Powder.WOOD_ASH).get(), grill.getAsh()));
                        grill.setAsh(0);
                        Helpers.playSound(level, pos, SoundEvents.f_12331_);
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)TFCItems.WROUGHT_IRON_GRILL.get()));
                    AbstractFirepitBlockEntity.convertTo((LevelAccessor)level, pos, state, grill, (Block)TFCBlocks.FIREPIT.get());
                }
                return InteractionResult.SUCCESS;
            }
            if (GrillBlock.tryInsertLog(player, stack, grill, result.m_82450_().f_82480_ - (double)pos.m_123342_() < 0.6)) {
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Helpers.openScreen(serverPlayer, (MenuProvider)grill, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean drawHighlight(Level level, BlockPos pos, Player player, BlockHitResult rayTrace, PoseStack stack, MultiBufferSource buffers, Vec3 rendererPosition) {
        int slot = GrillBlock.getSlotForSelection(rayTrace);
        if (slot != -1) {
            IHighlightHandler.drawBox(stack, SLOT_RENDER_SHAPES.get(slot), buffers, pos, rendererPosition, 1.0f, 0.0f, 0.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public double getParticleHeightOffset() {
        return 0.8;
    }
}

