/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.BurningLogPileBlockEntity;
import net.dries007.tfc.common.blockentities.LogPileBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;

public class BurningLogPileBlock
extends BaseEntityBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    private static final int TICK_DELAY = 30;
    private final ExtendedProperties properties;

    public static void lightLogPile(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LogPileBlockEntity) {
            LogPileBlockEntity pile = (LogPileBlockEntity)blockEntity;
            int logs = pile.logCount();
            pile.m_6211_();
            level.m_46597_(pos, ((Block)TFCBlocks.BURNING_LOG_PILE.get()).m_49966_());
            Helpers.playSound(level, pos, SoundEvents.f_11705_);
            BlockEntity blockEntity2 = level.m_7702_(pos);
            if (blockEntity2 instanceof BurningLogPileBlockEntity) {
                BurningLogPileBlockEntity burningPile = (BurningLogPileBlockEntity)blockEntity2;
                burningPile.light(logs);
                BurningLogPileBlock.tryLightNearby(level, pos);
            }
        }
    }

    public static void tryLightLogPile(Level level, BlockPos pos) {
        if (level.m_7702_(pos) instanceof LogPileBlockEntity) {
            level.m_186460_(pos, level.m_8055_(pos).m_60734_(), 30);
        }
    }

    private static boolean isValidCoverBlock(BlockState offsetState, Level level, BlockPos pos, Direction side) {
        if (Helpers.isBlock(offsetState, TFCTags.Blocks.CHARCOAL_COVER_WHITELIST)) {
            return true;
        }
        return !offsetState.isFlammable((BlockGetter)level, pos, side) && offsetState.m_60783_((BlockGetter)level, pos, side);
    }

    private static void tryLightNearby(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return;
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (Direction side : Helpers.DIRECTIONS) {
            cursor.m_122159_((Vec3i)pos, side);
            BlockState offsetState = level.m_8055_((BlockPos)cursor);
            if (BurningLogPileBlock.isValidCoverBlock(offsetState, level, (BlockPos)cursor, side.m_122424_())) {
                if (!Helpers.isBlock(offsetState, (Block)TFCBlocks.LOG_PILE.get())) continue;
                BurningLogPileBlock.tryLightLogPile(level, (BlockPos)cursor);
                continue;
            }
            if (offsetState.m_60795_()) {
                level.m_46597_((BlockPos)cursor, Blocks.f_50083_.m_49966_());
                continue;
            }
            if (level.f_46441_.m_188503_(7) != 0) continue;
            level.m_46597_(pos, Blocks.f_50083_.m_49966_());
            return;
        }
    }

    public BurningLogPileBlock(ExtendedProperties properties) {
        super(properties.properties());
        this.properties = properties;
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BurningLogPileBlock.tryLightNearby((Level)level, pos);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (level.m_8055_(pos.m_6630_(2)).m_247087_()) {
            double x = (float)pos.m_123341_() + rand.m_188501_();
            double y = (double)pos.m_123342_() + 1.125;
            double z = (float)pos.m_123343_() + rand.m_188501_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, (double)(0.1f + 0.1f * rand.m_188501_()), 0.0);
            if (rand.m_188503_(12) == 0) {
                level.m_7785_(x, y, z, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + rand.m_188501_(), rand.m_188501_() * 0.7f + 0.6f, false);
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123777_, x, y, z, (double)((0.5f - rand.m_188501_()) / 10.0f), (double)(0.1f + rand.m_188501_() / 8.0f), (double)((0.5f - rand.m_188501_()) / 10.0f));
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)Items.f_42414_);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }
}

