/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class BottomSupportedDeviceBlock
extends DeviceBlock {
    private final VoxelShape shape;

    public static boolean canSurvive(LevelReader level, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        BlockState state = level.m_8055_(below);
        return state.m_60783_((BlockGetter)level, below, Direction.UP) || Helpers.isBlock(state, TFCTags.Blocks.BOTTOM_SUPPORT_ACCEPTED);
    }

    protected BottomSupportedDeviceBlock(ExtendedProperties properties, DeviceBlock.InventoryRemoveBehavior removeBehavior) {
        this(properties, removeBehavior, Shapes.m_83144_());
    }

    protected BottomSupportedDeviceBlock(ExtendedProperties properties, DeviceBlock.InventoryRemoveBehavior removeBehavior, VoxelShape shape) {
        super(properties, removeBehavior);
        this.shape = shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return BottomSupportedDeviceBlock.canSurvive(level, pos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return BottomSupportedDeviceBlock.canSurvive((LevelReader)context.m_43725_(), context.m_8083_()) ? super.m_5573_(context) : null;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !BottomSupportedDeviceBlock.canSurvive((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }
}

