/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.crop.CropBlock;
import net.dries007.tfc.common.blocks.crop.DoubleCropBlock;
import net.dries007.tfc.common.blocks.crop.WildCropBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WildDoubleCropBlock
extends WildCropBlock {
    public static final EnumProperty<DoubleCropBlock.Part> PART = TFCBlockStateProperties.DOUBLE_CROP_PART;

    public static void onPlayerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            if (player.m_7500_()) {
                BlockPos blockpos;
                BlockState blockstate;
                if (state.m_61143_(PART) == DoubleCropBlock.Part.TOP && (blockstate = level.m_8055_(blockpos = pos.m_7495_())).m_60734_() == state.m_60734_() && blockstate.m_61143_(PART) == DoubleCropBlock.Part.BOTTOM) {
                    level.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
                    level.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
                }
            } else {
                WildDoubleCropBlock.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)level.m_7702_(pos), (Entity)player, (ItemStack)player.m_21205_());
            }
        }
    }

    public static boolean doubleBlockSurvives(BlockState state, LevelReader level, BlockPos pos) {
        DoubleCropBlock.Part part = (DoubleCropBlock.Part)((Object)state.m_61143_(PART));
        BlockState belowState = level.m_8055_(pos.m_7495_());
        if (part == DoubleCropBlock.Part.BOTTOM) {
            return Helpers.isBlock(belowState.m_60734_(), TFCTags.Blocks.WILD_CROP_GROWS_ON);
        }
        return Helpers.isBlock(belowState, state.m_60734_()) && belowState.m_61143_(PART) == DoubleCropBlock.Part.BOTTOM;
    }

    public WildDoubleCropBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(PART, (Comparable)((Object)DoubleCropBlock.Part.BOTTOM))).m_61124_((Property)MATURE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213898_(state, level, pos, random);
        if (state.m_61143_(PART) == DoubleCropBlock.Part.TOP) {
            BlockState below = level.m_8055_(pos.m_7495_());
            if (below.m_60734_() == this && (Boolean)below.m_61143_((Property)MATURE) != WildDoubleCropBlock.isMature((LevelAccessor)level)) {
                level.m_46597_(pos.m_7495_(), (BlockState)below.m_61122_((Property)MATURE));
            }
        } else {
            BlockState above = level.m_8055_(pos.m_7494_());
            if (above.m_60734_() == this && (Boolean)above.m_61143_((Property)MATURE) != WildDoubleCropBlock.isMature((LevelAccessor)level)) {
                level.m_46597_(pos.m_7494_(), (BlockState)above.m_61122_((Property)MATURE));
            }
        }
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.m_61143_(PART) == DoubleCropBlock.Part.BOTTOM ? CropBlock.FULL_SHAPE : CropBlock.HALF_SHAPE;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{PART}));
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return WildDoubleCropBlock.doubleBlockSurvives(state, level, pos);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        DoubleCropBlock.Part part = (DoubleCropBlock.Part)((Object)state.m_61143_(PART));
        if (facing.m_122434_() != Direction.Axis.Y || part == DoubleCropBlock.Part.BOTTOM != (facing == Direction.UP) || facingState.m_60734_() == this && facingState.m_61143_(PART) != part) {
            return part == DoubleCropBlock.Part.BOTTOM && facing == Direction.DOWN && !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        return pos.m_123342_() < context.m_43725_().m_151558_() - 1 && context.m_43725_().m_8055_(pos.m_7494_()).m_60629_(context) ? super.m_5573_(context) : null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            level.m_46597_(pos.m_7494_(), (BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)DoubleCropBlock.Part.TOP)));
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        WildDoubleCropBlock.onPlayerWillDestroy(level, pos, state, player);
        super.m_5707_(level, pos, state, player);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity tile, ItemStack stack) {
        super.m_6240_(level, player, pos, Blocks.f_50016_.m_49966_(), tile, stack);
    }

    public void placeTwoHalves(LevelAccessor level, BlockPos pos, int flags) {
        boolean mature = WildDoubleCropBlock.isMature(level);
        level.m_7731_(pos, (BlockState)((BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)DoubleCropBlock.Part.BOTTOM))).m_61124_((Property)MATURE, (Comparable)Boolean.valueOf(mature)), flags);
        level.m_7731_(pos.m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)DoubleCropBlock.Part.TOP))).m_61124_((Property)MATURE, (Comparable)Boolean.valueOf(mature)), flags);
    }
}

