/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ThinSpikeBlock
extends Block
implements IFluidLoggable {
    public static final VoxelShape PILLAR_SHAPE = ThinSpikeBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final VoxelShape TIP_SHAPE = Shapes.m_83110_((VoxelShape)ThinSpikeBlock.m_49796_((double)2.0, (double)5.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)ThinSpikeBlock.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0));
    public static final BooleanProperty TIP = TFCBlockStateProperties.TIP;
    public static final FluidProperty FLUID = TFCBlockStateProperties.WATER;

    public ThinSpikeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)TIP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FLUID, (Comparable)FLUID.keyFor(Fluids.f_76191_)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TIP, FLUID});
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        if (facing == Direction.DOWN) {
            return (BlockState)state.m_61124_((Property)TIP, (Comparable)Boolean.valueOf(!Helpers.isBlock(facingState, this)));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)TIP, (Comparable)Boolean.valueOf(true));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPos posDown;
        BlockState otherState;
        if (newState.m_60734_() != state.m_60734_() && (otherState = level.m_8055_(posDown = pos.m_7495_())).m_60734_() == this) {
            level.m_186460_(posDown, (Block)this, 0);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveState = level.m_8055_(abovePos);
        return aboveState.m_60734_() == this || aboveState.m_60783_((BlockGetter)level, abovePos, Direction.DOWN);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)TIP) != false ? TIP_SHAPE : PILLAR_SHAPE;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos pos = hit.m_82425_();
        if (!level.f_46443_ && projectile.m_142265_(level, pos) && Helpers.isEntity((Entity)projectile, EntityTypeTags.f_13124_)) {
            level.m_46953_(pos, true, (Entity)projectile);
        }
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidLoggedState(state);
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }
}

