/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.entity.BellBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class TFCBellBlock
extends BellBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    private final ExtendedProperties properties;
    private final float pitch;
    private final ResourceLocation textureLocation;

    public TFCBellBlock(ExtendedProperties properties, float pitch, String textureLocation) {
        this(properties, pitch, Helpers.identifier("entity/bell/" + textureLocation));
    }

    public TFCBellBlock(ExtendedProperties properties, float pitch, ResourceLocation textureLocation) {
        super(properties.properties());
        this.properties = properties;
        this.pitch = pitch;
        this.textureLocation = textureLocation;
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    public boolean m_152188_(@Nullable Entity entity, Level level, BlockPos pos, @Nullable Direction side) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!level.f_46443_ && blockEntity instanceof BellBlockEntity) {
            Player player;
            BellBlockEntity bell = (BellBlockEntity)blockEntity;
            if (side == null) {
                side = (Direction)level.m_8055_(pos).m_61143_((Property)f_49679_);
            }
            bell.m_58834_(side);
            boolean hard = entity instanceof Player && Helpers.isItem((player = (Player)entity).m_21205_(), TFCTags.Items.HAMMERS);
            level.m_5594_(null, pos, SoundEvents.f_11699_, SoundSource.BLOCKS, 2.0f, hard ? this.pitch - 0.1f : this.pitch);
            level.m_142346_(entity, GameEvent.f_157792_, pos);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return EntityBlockExtension.super.m_142194_(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return EntityBlockExtension.super.m_142354_(level, state, type);
    }
}

