/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.dries007.tfc.client.IHighlightHandler;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.JarsBlockEntity;
import net.dries007.tfc.common.blockentities.PlacedItemBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.util.Helpers;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public class JarsBlock
extends BottomSupportedDeviceBlock
implements IHighlightHandler {
    public static final BooleanProperty ITEM_0 = TFCBlockStateProperties.ITEM_0;
    public static final BooleanProperty ITEM_1 = TFCBlockStateProperties.ITEM_1;
    public static final BooleanProperty ITEM_2 = TFCBlockStateProperties.ITEM_2;
    public static final BooleanProperty ITEM_3 = TFCBlockStateProperties.ITEM_3;
    public static final BooleanProperty[] ITEM_PROPERTIES = new BooleanProperty[]{ITEM_0, ITEM_1, ITEM_2, ITEM_3};
    public static final VoxelShape SHAPE_1 = Shapes.m_83110_((VoxelShape)JarsBlock.m_49796_((double)10.0, (double)6.0, (double)10.0, (double)13.0, (double)7.0, (double)13.0), (VoxelShape)JarsBlock.m_49796_((double)9.0, (double)0.0, (double)9.0, (double)14.0, (double)6.0, (double)14.0));
    public static final VoxelShape SHAPE_2 = Shapes.m_83110_((VoxelShape)JarsBlock.m_49796_((double)2.0, (double)6.0, (double)10.0, (double)5.0, (double)7.0, (double)13.0), (VoxelShape)JarsBlock.m_49796_((double)1.0, (double)0.0, (double)9.0, (double)6.0, (double)6.0, (double)14.0));
    public static final VoxelShape SHAPE_3 = Shapes.m_83110_((VoxelShape)JarsBlock.m_49796_((double)10.0, (double)6.0, (double)2.0, (double)13.0, (double)7.0, (double)5.0), (VoxelShape)JarsBlock.m_49796_((double)9.0, (double)0.0, (double)1.0, (double)14.0, (double)6.0, (double)6.0));
    public static final VoxelShape SHAPE_4 = Shapes.m_83110_((VoxelShape)JarsBlock.m_49796_((double)2.0, (double)6.0, (double)2.0, (double)5.0, (double)7.0, (double)5.0), (VoxelShape)JarsBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)6.0, (double)6.0, (double)6.0));
    public static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_1, SHAPE_2, SHAPE_3, SHAPE_4};
    public static final AABB[] BOUNDS = (AABB[])Util.m_137537_(() -> {
        AABB[] aabb = new AABB[4];
        for (int i = 0; i < 4; ++i) {
            aabb[i] = SHAPES[i].m_83215_().m_82400_(0.01);
        }
        return aabb;
    });
    private final Map<BlockState, VoxelShape> cachedShapes;

    protected static Map<BlockState, VoxelShape> makeShapes(ImmutableList<BlockState> possibleStates) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : possibleStates) {
            VoxelShape shape = Shapes.m_83040_();
            for (int i = 0; i < 4; ++i) {
                if (!((Boolean)state.m_61143_((Property)ITEM_PROPERTIES[i])).booleanValue()) continue;
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPES[i]);
            }
            builder.put((Object)state, (Object)shape);
        }
        return builder.build();
    }

    public static BlockState updateStateValues(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof JarsBlockEntity) {
            JarsBlockEntity jars = (JarsBlockEntity)blockEntity;
            IItemHandler inv = Helpers.getCapability((ICapabilityProvider)jars, Capabilities.ITEM);
            if (inv == null) {
                return state;
            }
            for (int i = 0; i < 4; ++i) {
                state = (BlockState)state.m_61124_((Property)ITEM_PROPERTIES[i], (Comparable)Boolean.valueOf(!inv.getStackInSlot(i).m_41619_()));
            }
        }
        return state;
    }

    public static boolean isEmpty(BlockState state) {
        JarsBlock block;
        Block block2 = state.m_60734_();
        if (block2 instanceof JarsBlock && (block = (JarsBlock)block2).isPersistentWithNoItems()) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (!((Boolean)state.m_61143_((Property)ITEM_PROPERTIES[i])).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public JarsBlock(ExtendedProperties properties) {
        this(properties, true);
    }

    public JarsBlock(ExtendedProperties properties, boolean buildCache) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP, SHAPE_1);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ITEM_0, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ITEM_1, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ITEM_2, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ITEM_3, (Comparable)Boolean.valueOf(true)));
        this.cachedShapes = buildCache ? JarsBlock.makeShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_()) : new HashMap();
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        BlockState newShape = super.m_7417_(state, facing, facingState, level, pos, facingPos);
        if (newShape.m_60795_()) {
            return newShape;
        }
        BlockState updateState = JarsBlock.updateStateValues(level, pos, state);
        return JarsBlock.isEmpty(updateState) ? Blocks.f_50016_.m_49966_() : updateState;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.cachedShapes.get(state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof JarsBlockEntity) {
            JarsBlockEntity jars = (JarsBlockEntity)blockEntity;
            return jars.use(player, player.m_21120_(hand), hit) ? InteractionResult.m_19078_((boolean)level.f_46443_) : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean drawHighlight(Level level, BlockPos pos, Player player, BlockHitResult rayTrace, PoseStack stack, MultiBufferSource buffers, Vec3 rendererPosition) {
        if (!Helpers.isItem(player.m_21120_(InteractionHand.MAIN_HAND), TFCTags.Items.JARS) && !Helpers.isItem(player.m_21120_(InteractionHand.OFF_HAND), TFCTags.Items.JARS)) {
            return true;
        }
        int slot = PlacedItemBlockEntity.getSlotSelected(rayTrace);
        IHighlightHandler.drawBox(stack, SHAPES[slot], buffers, pos, rendererPosition, 1.0f, 0.0f, 0.0f, 1.0f);
        return BOUNDS[slot].m_82338_(pos).m_82390_(rayTrace.m_82450_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{ITEM_0, ITEM_1, ITEM_2, ITEM_3}));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected boolean isPersistentWithNoItems() {
        return false;
    }
}

