/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.dries007.tfc.common.blockentities.JarsBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.JarsBlock;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class JarShelfBlock
extends JarsBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final VoxelShape TOP_SHAPE = JarShelfBlock.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> cachedShapes = JarShelfBlock.makeShapesWithShelf((ImmutableList<BlockState>)this.m_49965_().m_61056_());

    private static Map<BlockState, VoxelShape> makeShapesWithShelf(ImmutableList<BlockState> possibleStates) {
        Map<BlockState, VoxelShape> shapes = JarShelfBlock.makeShapes(possibleStates);
        ImmutableMap.Builder map = new ImmutableMap.Builder();
        for (Map.Entry<BlockState, VoxelShape> entry : shapes.entrySet()) {
            map.put((Object)entry.getKey(), (Object)Shapes.m_83110_((VoxelShape)entry.getValue(), (VoxelShape)TOP_SHAPE));
        }
        return map.build();
    }

    public static boolean canHangOnWall(LevelReader level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos facePos = pos.m_121945_(facing);
        BlockState faceState = level.m_8055_(facePos);
        return faceState.m_60783_((BlockGetter)level, facePos, facing.m_122424_());
    }

    public JarShelfBlock(ExtendedProperties properties) {
        super(properties, false);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{FACING}));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.cachedShapes.get(state);
    }

    @Override
    protected boolean isPersistentWithNoItems() {
        return true;
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return JarShelfBlock.canHangOnWall(level, pos, state);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (BottomSupportedDeviceBlock.canSurvive((LevelReader)level, pos)) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
        return JarShelfBlock.canHangOnWall((LevelReader)context.m_43725_(), context.m_8083_(), state) ? state : null;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockEntity blockEntity = level.m_7702_(currentPos);
        if (blockEntity instanceof JarsBlockEntity) {
            JarsBlockEntity jars = (JarsBlockEntity)blockEntity;
            if (!JarShelfBlock.canSurvive((LevelReader)level, currentPos)) {
                jars.ejectInventory();
                jars.m_6211_();
            }
        }
        return facing == state.m_61143_((Property)FACING) && !facingState.m_60783_((BlockGetter)level, facingPos, facing.m_122424_()) ? Blocks.f_50016_.m_49966_() : JarShelfBlock.updateStateValues(level, currentPos, state);
    }
}

