/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.extensions.IForgeBlock;
import org.jetbrains.annotations.Nullable;

public interface IForgeBlockExtension
extends IForgeBlock {
    public ExtendedProperties getExtendedProperties();

    default public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return this.getExtendedProperties().getFlammability();
    }

    default public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return state.getFlammability(level, pos, direction) > 0;
    }

    default public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return this.getExtendedProperties().getFireSpreadSpeed();
    }

    @Nullable
    default public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob entity) {
        BlockPathTypes type = this.getExtendedProperties().getPathType();
        return type != null ? type : super.getBlockPathType(state, level, pos, entity);
    }

    default public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        return this.getExtendedProperties().getEnchantmentPower(state);
    }
}

