/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.GlassBasinBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GlassBasinBlock
extends DeviceBlock {
    public static final VoxelShape[] SHAPES = (VoxelShape[])Util.m_137537_(() -> {
        VoxelShape[] shapes = new VoxelShape[16];
        for (int i = 0; i < 16; ++i) {
            shapes[i] = GlassBasinBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(i + 1), (double)16.0);
        }
        return shapes;
    });

    public static boolean isValid(Level level, BlockPos pos) {
        if (!level.m_8055_(pos).m_60795_()) {
            return false;
        }
        for (Direction side : Helpers.DIRECTIONS) {
            if (side == Direction.UP || Helpers.isBlock(level.m_8055_(pos.m_121945_(side)), TFCTags.Blocks.GLASS_BASIN_BLOCKS)) continue;
            return false;
        }
        return true;
    }

    public GlassBasinBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.NOOP);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        GlassBasinBlockEntity basin;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GlassBasinBlockEntity && (basin = (GlassBasinBlockEntity)blockEntity).getAnimationTicks() > -1) {
            return SHAPES[Mth.m_14143_((float)Mth.m_184631_((float)basin.getAnimationTicks(), (float)0.0f, (float)60.0f, (float)0.0f, (float)15.0f))];
        }
        return SHAPES[0];
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        LivingEntity living;
        if (entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)(living = (LivingEntity)entity))) {
            entity.m_6469_(level.m_269111_().m_269047_(), 1.0f);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

