/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ExtendedProperties {
    private final BlockBehaviour.Properties properties;
    @Nullable
    private BiFunction<BlockPos, BlockState, ? extends BlockEntity> blockEntityFactory;
    @Nullable
    private Supplier<? extends BlockEntityType<?>> blockEntityType;
    @Nullable
    private BlockEntityTicker<?> serverTicker;
    @Nullable
    private BlockEntityTicker<?> clientTicker;
    private int flammability;
    private int fireSpreadSpeed;
    @Nullable
    private BlockPathTypes pathType;
    private ToDoubleFunction<BlockState> enchantmentPowerGetter;

    public static ExtendedProperties of(BlockBehaviour.Properties properties) {
        return new ExtendedProperties(properties);
    }

    public static ExtendedProperties of(BlockBehaviour block) {
        return ExtendedProperties.of(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block));
    }

    public static ExtendedProperties of() {
        return ExtendedProperties.of(BlockBehaviour.Properties.m_284310_());
    }

    public static ExtendedProperties of(DyeColor color) {
        return ExtendedProperties.of(BlockBehaviour.Properties.m_284310_().m_284268_(color));
    }

    public static ExtendedProperties of(MapColor materialColor) {
        return ExtendedProperties.of(BlockBehaviour.Properties.m_284310_().m_284180_(materialColor));
    }

    public static ExtendedProperties of(Function<BlockState, MapColor> materialColor) {
        return ExtendedProperties.of(BlockBehaviour.Properties.m_284310_().m_284495_(materialColor));
    }

    private ExtendedProperties(BlockBehaviour.Properties properties) {
        this.properties = properties;
        this.blockEntityFactory = null;
        this.blockEntityType = null;
        this.serverTicker = null;
        this.clientTicker = null;
        this.flammability = 0;
        this.fireSpreadSpeed = 0;
        this.pathType = null;
        this.enchantmentPowerGetter = s -> 0.0;
    }

    public ExtendedProperties blockEntity(Supplier<? extends BlockEntityType<?>> blockEntityType) {
        this.blockEntityType = blockEntityType;
        this.blockEntityFactory = (pos, state) -> ((BlockEntityType)blockEntityType.get()).m_155264_(pos, state);
        return this;
    }

    public <T extends BlockEntity> ExtendedProperties ticks(BlockEntityTicker<T> ticker) {
        return this.ticks(ticker, ticker);
    }

    public <T extends BlockEntity> ExtendedProperties serverTicks(BlockEntityTicker<T> serverTicker) {
        return this.ticks(serverTicker, null);
    }

    public <T extends BlockEntity> ExtendedProperties clientTicks(BlockEntityTicker<T> clientTicker) {
        return this.ticks(null, clientTicker);
    }

    public <T extends BlockEntity> ExtendedProperties ticks(@Nullable BlockEntityTicker<T> serverTicker, @Nullable BlockEntityTicker<T> clientTicker) {
        assert (this.blockEntityType != null) : "Must call .blockEntity() before adding a ticker";
        assert (this.serverTicker == null && this.clientTicker == null) : "Calling ticks() twice, can only call one of ticks(), clientTicks(), or serverTicks()";
        this.serverTicker = serverTicker;
        this.clientTicker = clientTicker;
        return this;
    }

    public ExtendedProperties flammable(int flammability, int fireSpreadSpeed) {
        this.flammability = flammability;
        this.fireSpreadSpeed = fireSpreadSpeed;
        return this;
    }

    public ExtendedProperties flammableLikeLogs() {
        return this.flammable(5, 5).ignitedByLava();
    }

    public ExtendedProperties flammableLikePlanks() {
        return this.flammable(20, 5).ignitedByLava();
    }

    public ExtendedProperties flammableLikeLeaves() {
        return this.flammable(60, 30).ignitedByLava();
    }

    public ExtendedProperties flammableLikeWool() {
        return this.flammable(100, 60).ignitedByLava();
    }

    public ExtendedProperties pathType(BlockPathTypes type) {
        this.pathType = type;
        return this;
    }

    public ExtendedProperties enchantPower(float power) {
        this.enchantmentPowerGetter = s -> power;
        return this;
    }

    public ExtendedProperties enchantPower(ToDoubleFunction<BlockState> powerGetter) {
        this.enchantmentPowerGetter = powerGetter;
        return this;
    }

    public BlockBehaviour.Properties properties() {
        return this.properties;
    }

    @ApiStatus.Internal
    public boolean hasBlockEntity() {
        return this.blockEntityType != null;
    }

    public <T extends BlockEntity> BlockEntityType<T> blockEntity() {
        assert (this.blockEntityType != null);
        return this.blockEntityType.get();
    }

    public ExtendedProperties noCollission() {
        this.properties.m_60910_();
        return this;
    }

    public ExtendedProperties noOcclusion() {
        this.properties.m_60955_();
        return this;
    }

    public ExtendedProperties friction(float friction) {
        this.properties.m_60911_(friction);
        return this;
    }

    public ExtendedProperties speedFactor(float speedFactor) {
        this.properties.m_60956_(speedFactor);
        return this;
    }

    public ExtendedProperties jumpFactor(float jumpFactor) {
        this.properties.m_60967_(jumpFactor);
        return this;
    }

    public ExtendedProperties sound(SoundType sound) {
        this.properties.m_60918_(sound);
        return this;
    }

    public ExtendedProperties lightLevel(ToIntFunction<BlockState> lightLevel) {
        this.properties.m_60953_(lightLevel);
        return this;
    }

    public ExtendedProperties strength(float destroyTime, float explosionResistance) {
        this.properties.m_60913_(destroyTime, explosionResistance);
        return this;
    }

    public ExtendedProperties instabreak() {
        this.properties.m_60966_();
        return this;
    }

    public ExtendedProperties strength(float strength) {
        this.properties.m_60978_(strength);
        return this;
    }

    public ExtendedProperties randomTicks() {
        this.properties.m_60977_();
        return this;
    }

    public ExtendedProperties dynamicShape() {
        this.properties.m_60988_();
        return this;
    }

    public ExtendedProperties noLootTable() {
        this.properties.m_222994_();
        return this;
    }

    public ExtendedProperties dropsLike(Block block) {
        this.properties.lootFrom(() -> block);
        return this;
    }

    public ExtendedProperties dropsLike(Supplier<Block> block) {
        this.properties.lootFrom(block);
        return this;
    }

    public ExtendedProperties air() {
        this.properties.m_60996_();
        return this;
    }

    public ExtendedProperties isValidSpawn(BlockBehaviour.StateArgumentPredicate<EntityType<?>> isValidSpawn) {
        this.properties.m_60922_(isValidSpawn);
        return this;
    }

    public ExtendedProperties isRedstoneConductor(BlockBehaviour.StatePredicate isRedstoneConductor) {
        this.properties.m_60924_(isRedstoneConductor);
        return this;
    }

    public ExtendedProperties isSuffocating(BlockBehaviour.StatePredicate isSuffocating) {
        this.properties.m_60960_(isSuffocating);
        return this;
    }

    public ExtendedProperties isViewBlocking(BlockBehaviour.StatePredicate isViewBlocking) {
        this.properties.m_60971_(isViewBlocking);
        return this;
    }

    public ExtendedProperties hasPostProcess(BlockBehaviour.StatePredicate hasPostProcess) {
        this.properties.m_60982_(hasPostProcess);
        return this;
    }

    public ExtendedProperties emissiveRendering(BlockBehaviour.StatePredicate emissiveRendering) {
        this.properties.m_60991_(emissiveRendering);
        return this;
    }

    public ExtendedProperties requiresCorrectToolForDrops() {
        this.properties.m_60999_();
        return this;
    }

    public ExtendedProperties mapColor(MapColor color) {
        this.properties.m_284180_(color);
        return this;
    }

    public ExtendedProperties mapColor(Function<BlockState, MapColor> mapColor) {
        this.properties.m_284495_(mapColor);
        return this;
    }

    public ExtendedProperties mapColor(DyeColor color) {
        this.properties.m_284268_(color);
        return this;
    }

    public ExtendedProperties destroyTime(float destroyTime) {
        this.properties.m_155954_(destroyTime);
        return this;
    }

    public ExtendedProperties explosionResistance(float explosionResistance) {
        this.properties.m_155956_(explosionResistance);
        return this;
    }

    public ExtendedProperties ignitedByLava() {
        this.properties.m_278183_();
        return this;
    }

    public ExtendedProperties liquid() {
        this.properties.m_278788_();
        return this;
    }

    public ExtendedProperties forceSolidOn() {
        this.properties.m_280606_();
        return this;
    }

    public ExtendedProperties forceSolidOff() {
        this.properties.m_280574_();
        return this;
    }

    public ExtendedProperties pushReaction(PushReaction reaction) {
        this.properties.m_278166_(reaction);
        return this;
    }

    public ExtendedProperties offsetType(BlockBehaviour.OffsetType type) {
        this.properties.m_222979_(type);
        return this;
    }

    public ExtendedProperties noParticlesOnBreak() {
        this.properties.m_246721_();
        return this;
    }

    public ExtendedProperties requiredFeatures(FeatureFlag ... flags) {
        this.properties.m_246843_(flags);
        return this;
    }

    public ExtendedProperties instrument(NoteBlockInstrument inst) {
        this.properties.m_280658_(inst);
        return this;
    }

    public ExtendedProperties defaultInstrument() {
        return this.instrument(NoteBlockInstrument.HARP);
    }

    public ExtendedProperties replaceable() {
        this.properties.m_280170_();
        return this;
    }

    @Nullable
    BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.blockEntityFactory == null ? null : this.blockEntityFactory.apply(pos, state);
    }

    @Nullable
    <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockEntityType<T> givenType) {
        assert (this.blockEntityType != null);
        if (givenType == this.blockEntityType.get()) {
            return level.m_5776_() ? this.clientTicker : this.serverTicker;
        }
        return null;
    }

    int getFlammability() {
        return this.flammability;
    }

    int getFireSpreadSpeed() {
        return this.fireSpreadSpeed;
    }

    @Nullable
    BlockPathTypes getPathType() {
        return this.pathType;
    }

    float getEnchantmentPower(BlockState state) {
        return (float)this.enchantmentPowerGetter.applyAsDouble(state);
    }
}

