/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public interface DirectionPropertyBlock {
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final ImmutableMap<BooleanProperty, Direction> TO_DIRECTION = ImmutableMap.builder().put((Object)BlockStateProperties.f_61367_, (Object)Direction.DOWN).put((Object)BlockStateProperties.f_61366_, (Object)Direction.UP).put((Object)BlockStateProperties.f_61368_, (Object)Direction.NORTH).put((Object)BlockStateProperties.f_61370_, (Object)Direction.SOUTH).put((Object)BlockStateProperties.f_61371_, (Object)Direction.WEST).put((Object)BlockStateProperties.f_61369_, (Object)Direction.EAST).build();
    public static final BooleanProperty[] PROPERTIES = new BooleanProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};

    @NotNull
    public static BooleanProperty getProperty(Direction direction) {
        return PROPERTIES[direction.ordinal()];
    }

    @NotNull
    public static Direction getDirection(BooleanProperty property) {
        return (Direction)TO_DIRECTION.get((Object)property);
    }

    public static BlockState setAllDirections(BlockState state, boolean value) {
        for (BooleanProperty property : PROPERTIES) {
            state = (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(value));
        }
        return state;
    }

    public static Map<BlockState, VoxelShape> makeShapeCache(StateDefinition<Block, BlockState> stateDefinition, Function<BooleanProperty, VoxelShape> toShape) {
        return stateDefinition.m_61056_().stream().collect(Collectors.toUnmodifiableMap(Function.identity(), state -> Arrays.stream(PROPERTIES).filter(arg_0 -> ((BlockState)state).m_61143_(arg_0)).map(toShape).reduce(Shapes::m_83110_).orElseGet(Shapes::m_83040_)));
    }

    public static BlockState rotate(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)));
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            default -> state;
        };
    }

    public static BlockState mirror(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            default -> state;
        };
    }
}

