/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.BowlBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTraits;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.common.capabilities.glass.GlassOperation;
import net.dries007.tfc.common.capabilities.glass.GlassWorkData;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BowlBlock
extends DeviceBlock {
    public static final VoxelShape SHAPE = BowlBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0);

    public BowlBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BowlBlockEntity bowl;
        IItemHandler inv;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BowlBlockEntity && (inv = Helpers.getCapability((ICapabilityProvider)(bowl = (BowlBlockEntity)blockEntity), Capabilities.ITEM)) != null) {
            IFood food;
            ItemStack held = player.m_21120_(hand);
            ItemStack current = inv.getStackInSlot(0);
            GlassWorkData data = GlassWorkData.get(held);
            if (data != null && !data.getBatch().m_41619_()) {
                GlassOperation op = GlassOperation.getByPowder(current);
                if (op != null) {
                    GlassWorkData.apply(held, op);
                    inv.getStackInSlot(0).m_41774_(1);
                    Helpers.playSound(level, pos, SoundEvents.f_12334_);
                    player.m_36335_().m_41524_(held.m_41720_(), 10);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                return InteractionResult.PASS;
            }
            if (held.m_41619_() && hand == InteractionHand.MAIN_HAND) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)inv.extractItem(0, player.m_6144_() ? 16 : 1, false));
                Helpers.playSound(level, pos, SoundEvents.f_12334_);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (Helpers.isItem(held, TFCTags.Items.POWDERS)) {
                player.m_21008_(hand, Helpers.insertAllSlots(inv, held));
                Helpers.playSound(level, pos, SoundEvents.f_12334_);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (Helpers.isItem(held, TFCTags.Items.CAN_BE_SALTED) && Helpers.isItem(current, (Item)TFCItems.POWDERS.get((Object)Powder.SALT).get()) && (food = FoodCapability.get(held)) != null && !food.hasTrait(FoodTraits.SALTED)) {
                int toSalt = Math.min(held.m_41613_(), current.m_41613_());
                ItemStack salted = held.m_41620_(toSalt);
                FoodCapability.applyTrait(salted, FoodTraits.SALTED);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)salted);
                inv.getStackInSlot(0).m_41774_(toSalt);
                Helpers.playSound(level, pos, SoundEvents.f_12334_);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }
}

