/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities.rotation;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blockentities.AnvilBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.BladedAxleBlockEntity;
import net.dries007.tfc.common.blocks.TripHammerBlock;
import net.dries007.tfc.common.blocks.devices.AnvilBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.forge.ForgeStep;
import net.dries007.tfc.common.items.HammerItem;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.rotation.Rotation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class TripHammerBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler> {
    private int cooldownTicks = 10;
    private static final Component NAME = Component.m_237115_((String)"tfc.block_entity.trip_hammer");

    public static void serverTick(Level level, BlockPos pos, BlockState state, TripHammerBlockEntity hammer) {
        float angle;
        if (hammer.cooldownTicks-- > 0) {
            return;
        }
        ItemStack item = ((ItemStackHandler)hammer.inventory).getStackInSlot(0);
        if (item.m_41619_()) {
            return;
        }
        Rotation rotation = hammer.getRotation();
        if (rotation != null && (angle = hammer.getRealRotationDegrees(rotation, 1.0f)) > 180.0f && angle < 183.0f) {
            if (rotation.positiveDirection() != ((Direction)state.m_61143_((Property)TripHammerBlock.FACING)).m_122427_()) {
                level.m_46961_(pos, true);
                return;
            }
            BlockPos anvilPos = pos.m_121945_((Direction)state.m_61143_((Property)TripHammerBlock.FACING));
            BlockEntity blockEntity = level.m_7702_(anvilPos);
            if (blockEntity instanceof AnvilBlockEntity) {
                AnvilBlockEntity anvil = (AnvilBlockEntity)blockEntity;
                if (level.m_8055_(anvilPos).m_60734_() instanceof AnvilBlock) {
                    if (!anvil.workRemotely(ForgeStep.HIT_LIGHT, 12, true)) {
                        if (anvil.getCapability(Capabilities.ITEM).map(inv -> !inv.getStackInSlot(0).m_41619_()).orElse(false).booleanValue()) {
                            level.m_5594_(null, pos, (SoundEvent)TFCSounds.ANVIL_HIT.get(), SoundSource.BLOCKS, 0.4f, 0.2f);
                        }
                    } else {
                        Helpers.damageItem(item, 1);
                        anvil.markForSync();
                    }
                    hammer.cooldownTicks = Mth.m_14167_((float)(5.0265484f / rotation.positiveSpeed()));
                }
            }
        }
    }

    public TripHammerBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.TRIP_HAMMER.get(), pos, state);
    }

    public TripHammerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, TripHammerBlockEntity.defaultInventory(1), NAME);
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.markForSync();
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        HammerItem hammer;
        Item item = stack.m_41720_();
        return item instanceof HammerItem && (hammer = (HammerItem)item).getMetalTexture() != null;
    }

    public float getRealRotationDegrees(Rotation rotation, float partialTick) {
        return 57.295776f * rotation.angle(partialTick);
    }

    @Nullable
    public Rotation getRotation() {
        assert (this.f_58857_ != null);
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        if (blockEntity instanceof BladedAxleBlockEntity) {
            BladedAxleBlockEntity axle = (BladedAxleBlockEntity)blockEntity;
            return axle.getRotationNode().rotation();
        }
        return null;
    }
}

