/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities.rotation;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Set;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.CrankshaftBlockEntity;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rotation.FluidPumpBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.rotation.Rotation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class PumpBlockEntity
extends TFCBlockEntity {
    private static final int MAX_COST = 16;
    private static final int MAX_FILL = 32;

    public static void serverTick(Level level, BlockPos pos, BlockState state, PumpBlockEntity pump) {
        if (level.m_46467_() % 40L == 0L) {
            Fluid fluid;
            Direction face = (Direction)state.m_61143_(FluidPumpBlock.FACING);
            BlockPos outputPos = pos.m_121945_(face);
            BlockState outputState = level.m_8055_(outputPos);
            @Nullable CrankshaftBlockEntity shaft = CrankshaftBlockEntity.getCrankShaftAt((LevelAccessor)level, pos, face.m_122424_());
            Fluid fluid2 = fluid = PumpBlockEntity.isRotating(shaft) ? PumpBlockEntity.searchForFluid(level, pos) : null;
            if (fluid != null) {
                BlockState newState = FluidHelpers.fillWithFluid(outputState, fluid);
                if (newState != null && newState != outputState) {
                    level.m_46597_(outputPos, newState);
                    level.m_186469_(outputPos, fluid, fluid.m_6718_((LevelReader)level));
                }
                if (newState == outputState) {
                    PumpBlockEntity.floodFill(level, pos, outputPos, fluid);
                }
            } else {
                PumpBlockEntity.removePlacedFluid(level, outputPos, outputState);
            }
        }
    }

    private static boolean isRotating(@Nullable CrankshaftBlockEntity shaft) {
        if (shaft != null) {
            Rotation rotation = shaft.getRotationNode().rotation();
            return rotation != null && rotation.speed() != 0.0f;
        }
        return false;
    }

    @Nullable
    private static Fluid searchForFluid(Level level, BlockPos start) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        ArrayDeque<Path> queue = new ArrayDeque<Path>();
        ObjectOpenHashSet seen = new ObjectOpenHashSet(64);
        BlockPos below = start.m_7495_();
        BlockState stateBelow = level.m_8055_(below);
        if (!PumpBlockEntity.isPipe(stateBelow)) {
            return null;
        }
        PumpBlockEntity.enqueueConnections(cursor, level, new Path(stateBelow, below, 1), (Set<BlockPos>)seen, queue);
        while (!queue.isEmpty()) {
            Path prev = (Path)queue.poll();
            Fluid fluid = PumpBlockEntity.enqueueConnections(cursor, level, prev, (Set<BlockPos>)seen, queue);
            if (fluid == null) continue;
            return fluid;
        }
        return null;
    }

    @Nullable
    private static Fluid enqueueConnections(BlockPos.MutableBlockPos cursor, Level level, Path prev, Set<BlockPos> seen, Queue<Path> queue) {
        for (Direction direction : Helpers.DIRECTIONS) {
            cursor.m_122159_((Vec3i)prev.pos, direction);
            if (seen.contains(cursor)) continue;
            BlockState stateAdj = level.m_8055_((BlockPos)cursor);
            if (PumpBlockEntity.isPipe(stateAdj)) {
                if (prev.cost >= 16) continue;
                BlockPos posAdj = cursor.m_7949_();
                queue.add(new Path(stateAdj, posAdj, 1 + prev.cost));
                seen.add(posAdj);
                continue;
            }
            if (!((Boolean)prev.state.m_61143_((Property)DirectionPropertyBlock.getProperty(direction))).booleanValue() || prev.state.m_60819_().m_76178_() || prev.state.m_60819_().m_76152_() != stateAdj.m_60819_().m_76152_() || !FluidHelpers.isAirOrEmptyFluid(stateAdj)) continue;
            return stateAdj.m_60819_().m_76152_();
        }
        return null;
    }

    private static void floodFill(Level level, BlockPos sourcePos, BlockPos pos, Fluid fluid) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        ObjectOpenHashSet seen = new ObjectOpenHashSet(64);
        BlockPos nextPos = null;
        int total = 0;
        queue.add(pos);
        seen.add(pos);
        seen.add(sourcePos);
        while (!queue.isEmpty()) {
            BlockPos prev = (BlockPos)queue.poll();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                cursor.m_122159_((Vec3i)prev, direction);
                if (seen.contains(cursor)) continue;
                BlockPos current = cursor.m_7949_();
                seen.add(current);
                BlockState stateAt = level.m_8055_((BlockPos)cursor);
                if (stateAt.m_60795_() || PumpBlockEntity.isSourceOrFlowingFluidOf(stateAt, fluid)) {
                    cursor.m_122184_(0, -1, 0);
                    BlockState stateBelow = level.m_8055_((BlockPos)cursor);
                    if (stateBelow.m_60819_().m_164512_(fluid) || stateBelow.m_60783_((BlockGetter)level, (BlockPos)cursor, Direction.UP)) {
                        if (nextPos == null && (stateAt.m_60795_() || !stateAt.m_60819_().m_76170_())) {
                            nextPos = current;
                        }
                        if (++total >= 32) {
                            return;
                        }
                        queue.add(current);
                        continue;
                    }
                    return;
                }
                if (stateAt.m_60783_((BlockGetter)level, (BlockPos)cursor, direction.m_122424_())) continue;
                return;
            }
        }
        if (nextPos != null) {
            level.m_46597_(nextPos, fluid.m_76145_().m_76188_());
            level.m_186469_(nextPos, fluid, fluid.m_6718_((LevelReader)level));
        }
    }

    private static void removePlacedFluid(Level level, BlockPos outputPos, BlockState outputState) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            cursor.m_122159_((Vec3i)outputPos, direction);
            if (!level.m_6425_((BlockPos)cursor).m_164512_(outputState.m_60819_().m_76152_())) continue;
            return;
        }
        level.m_46597_(outputPos, FluidHelpers.emptyFluidFrom(outputState));
    }

    private static boolean isSourceOrFlowingFluidOf(BlockState state, Fluid fluid) {
        boolean bl;
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowing = (FlowingFluid)fluid;
            bl = flowing.m_6212_(state.m_60819_().m_76152_());
        } else {
            bl = fluid == state.m_60819_().m_76152_();
        }
        return bl;
    }

    private static boolean isPipe(BlockState state) {
        return state.m_60734_() == TFCBlocks.STEEL_PIPE.get();
    }

    public PumpBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.PUMP.get(), pos, state);
    }

    protected PumpBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void onRemoved() {
        assert (this.f_58857_ != null);
        Direction face = (Direction)this.m_58900_().m_61143_(FluidPumpBlock.FACING);
        BlockPos outputPos = this.f_58858_.m_121945_(face);
        BlockState outputState = this.f_58857_.m_8055_(outputPos);
        PumpBlockEntity.removePlacedFluid(this.f_58857_, outputPos, outputState);
    }

    private record Path(BlockState state, BlockPos pos, int cost) {
    }
}

