/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities.rotation;

import java.util.EnumSet;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.RotatingBlockEntity;
import net.dries007.tfc.common.blocks.rotation.HandWheelBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.rotation.NetworkAction;
import net.dries007.tfc.util.rotation.Node;
import net.dries007.tfc.util.rotation.SourceNode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;

public class HandWheelBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler>
implements RotatingBlockEntity {
    public static final int MAX_ROTATION_TICKS = 80;
    public static final float SPEED = 0.07853982f;
    private static final Component NAME = Component.m_237115_((String)"tfc.block_entity.hand_wheel");
    private static final int SLOT_WHEEL = 0;
    private final SourceNode node;
    private int rotationTimer = 0;
    private boolean needsStateUpdate = false;
    private boolean invalid;

    public static void serverTick(Level level, BlockPos pos, BlockState state, HandWheelBlockEntity wheel) {
        wheel.checkForLastTickSync();
        HandWheelBlockEntity.clientTick(level, pos, state, wheel);
        if (wheel.needsStateUpdate) {
            wheel.updateWheel();
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, HandWheelBlockEntity wheel) {
        if (wheel.rotationTimer > 0) {
            --wheel.rotationTimer;
            wheel.node.rotation().tick();
            if (wheel.rotationTimer == 0) {
                wheel.node.rotation().reset();
            }
        }
    }

    public HandWheelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, HandWheelBlockEntity.defaultInventory(1), NAME);
        final Direction outputDirection = (Direction)state.m_61143_((Property)HandWheelBlock.FACING);
        this.invalid = false;
        this.node = new SourceNode(pos, EnumSet.of(outputDirection), outputDirection.m_122424_(), 0.0f){

            @Override
            public String toString() {
                return "HandWheel[pos=%s, direction=%s]".formatted(this.pos(), outputDirection);
            }
        };
    }

    public HandWheelBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.HAND_WHEEL.get(), pos, state);
    }

    public ItemStack viewStack() {
        return ((ItemStackHandler)this.inventory).getStackInSlot(0);
    }

    public void rotate() {
        assert (this.f_58857_ != null);
        if (this.rotationTimer == 0) {
            this.node.rotation().set(0.0f, 0.07853982f);
        }
        this.rotationTimer = 80;
        this.markForSync();
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.needsStateUpdate = true;
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.isItem(stack.m_41720_(), TFCTags.Items.HAND_WHEEL);
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.rotationTimer = nbt.m_128451_("rotationTimer");
        this.invalid = nbt.m_128471_("invalid");
        super.loadAdditional(nbt);
        this.needsStateUpdate = true;
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("rotationTimer", this.rotationTimer);
        nbt.m_128379_("invalid", this.invalid);
        super.m_183515_(nbt);
    }

    @Override
    protected void onLoadAdditional() {
        this.performNetworkAction(NetworkAction.ADD_SOURCE);
    }

    @Override
    protected void onUnloadAdditional() {
        this.performNetworkAction(NetworkAction.REMOVE);
    }

    @Override
    public void markAsInvalidInNetwork() {
        this.invalid = true;
    }

    @Override
    public boolean isInvalidInNetwork() {
        return this.invalid;
    }

    @Override
    public Node getRotationNode() {
        return this.node;
    }

    private boolean hasWheel() {
        return !((ItemStackHandler)this.inventory).getStackInSlot(0).m_41619_();
    }

    private void updateWheel() {
        assert (this.f_58857_ != null);
        BlockState state = this.m_58900_();
        BlockState newState = (BlockState)state.m_61124_((Property)HandWheelBlock.HAS_WHEEL, (Comparable)Boolean.valueOf(this.hasWheel()));
        this.f_58857_.m_46597_(this.f_58858_, newState);
        this.needsStateUpdate = false;
    }
}

