/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities.rotation;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.RotatingBlockEntity;
import net.dries007.tfc.common.blocks.rotation.AxleBlock;
import net.dries007.tfc.util.rotation.AxleNode;
import net.dries007.tfc.util.rotation.NetworkAction;
import net.dries007.tfc.util.rotation.Node;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AxleBlockEntity
extends TFCBlockEntity
implements RotatingBlockEntity {
    private final Node node;
    private boolean invalid;

    public AxleBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.AXLE.get(), pos, state);
    }

    protected AxleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        final Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)AxleBlock.f_55923_);
        this.invalid = false;
        this.node = new AxleNode(pos, Node.ofAxis(axis)){

            @Override
            protected void onInvalidConnection() {
                AxleBlockEntity.this.onInvalidConnection();
            }

            @Override
            public String toString() {
                return "Axle[pos=%s, axis=%s]".formatted(axis, this.pos());
            }
        };
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("invalid", this.invalid);
    }

    @Override
    protected void loadAdditional(CompoundTag tag) {
        super.loadAdditional(tag);
        this.invalid = tag.m_128471_("invalid");
    }

    @Override
    protected void onLoadAdditional() {
        this.performNetworkAction(NetworkAction.ADD);
    }

    @Override
    protected void onUnloadAdditional() {
        this.performNetworkAction(NetworkAction.REMOVE);
    }

    @Override
    public void markAsInvalidInNetwork() {
        this.invalid = true;
    }

    @Override
    public boolean isInvalidInNetwork() {
        return this.invalid;
    }

    @Override
    public Node getRotationNode() {
        return this.node;
    }

    private void onInvalidConnection() {
        if (this.f_58857_ != null) {
            this.markAsInvalidInNetwork();
            this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), 4);
        }
    }
}

