/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.recipes.ScrapingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class ScrapingBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    private static final Component NAME = Component.m_237115_((String)"tfc.block_entity.scraping");
    private static final float[] NO_COLOR = new float[]{1.0f, 1.0f, 1.0f};
    @Nullable
    private ResourceLocation inputTexture = null;
    @Nullable
    private ResourceLocation outputTexture = null;
    private short positions = 0;
    @Nullable
    private DyeColor color1 = null;
    @Nullable
    private DyeColor color2 = null;

    public ScrapingBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.SCRAPING.get(), pos, state, ScrapingBlockEntity.defaultInventory(1), NAME);
    }

    public boolean isComplete() {
        return this.positions == -1;
    }

    public short getScrapedPositions() {
        return this.positions;
    }

    public void onClicked(float hitX, float hitZ) {
        int xPos = (int)(hitX * 4.0f);
        int zPos = (int)(hitZ * 4.0f);
        this.positions = (short)(this.positions | 1 << xPos + zPos * 4);
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            ItemStack currentItem;
            ScrapingRecipe recipe;
            if (this.isComplete() && (recipe = this.getRecipe(currentItem = ((ItemStackHandler)this.inventory).getStackInSlot(0))) != null) {
                ItemStack extraDrop = recipe.getExtraDrop().getSingleStack(currentItem);
                if (!extraDrop.m_41619_()) {
                    Helpers.spawnItem(this.f_58857_, this.f_58858_, extraDrop);
                }
                ((ItemStackHandler)this.inventory).setStackInSlot(0, recipe.assemble(new ItemStackInventory(currentItem), this.f_58857_.m_9598_()));
            }
            this.markForBlockUpdate();
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
    }

    public boolean dye(DyeColor color) {
        if (this.color1 == null) {
            this.color1 = color;
            this.markForBlockUpdate();
            return true;
        }
        if (this.color2 == null) {
            this.color2 = color;
            this.markForBlockUpdate();
            return true;
        }
        return false;
    }

    public float[] getColor1() {
        return this.color1 != null ? this.color1.m_41068_() : NO_COLOR;
    }

    public float[] getColor2() {
        return this.color2 != null ? this.color2.m_41068_() : NO_COLOR;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return this.getRecipe(stack) != null;
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        super.loadAdditional(nbt);
        this.positions = nbt.m_128448_("positions");
        this.inputTexture = nbt.m_128425_("inputTexture", 8) ? Helpers.resourceLocation(nbt.m_128461_("inputTexture")) : null;
        this.outputTexture = nbt.m_128425_("outputTexture", 8) ? Helpers.resourceLocation(nbt.m_128461_("outputTexture")) : null;
        this.color1 = nbt.m_128425_("color1", 3) ? DyeColor.m_41053_((int)nbt.m_128451_("color1")) : null;
        this.color2 = nbt.m_128425_("color2", 3) ? DyeColor.m_41053_((int)nbt.m_128451_("color2")) : null;
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128376_("positions", this.positions);
        if (this.inputTexture != null) {
            nbt.m_128359_("inputTexture", this.inputTexture.toString());
        }
        if (this.outputTexture != null) {
            nbt.m_128359_("outputTexture", this.outputTexture.toString());
        }
        if (this.color1 != null) {
            nbt.m_128405_("color1", this.color1.m_41060_());
        }
        if (this.color2 != null) {
            nbt.m_128405_("color2", this.color2.m_41060_());
        }
        super.m_183515_(nbt);
    }

    @Nullable
    public ResourceLocation getInputTexture() {
        return this.inputTexture;
    }

    @Nullable
    public ResourceLocation getOutputTexture() {
        return this.outputTexture;
    }

    public void updateDisplayCache() {
        if (!this.isComplete()) {
            ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(0);
            ScrapingRecipe recipe = this.getRecipe(stack);
            this.inputTexture = recipe == null ? null : recipe.getInputTexture();
            this.outputTexture = recipe == null ? null : recipe.getOutputTexture();
        }
    }

    @Nullable
    private ScrapingRecipe getRecipe(ItemStack stack) {
        assert (this.f_58857_ != null);
        return ScrapingRecipe.getRecipe(this.f_58857_, new ItemStackInventory(stack));
    }
}

