/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.function.Predicate;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.recipes.LoomRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class LoomBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler> {
    private static final Component NAME = Component.m_237115_((String)"tfc.block_entity.loom");
    private static final int SLOT_RECIPE = 0;
    private static final int SLOT_OUTPUT = 1;
    @Nullable
    private LoomRecipe recipe = null;
    @Nullable
    private ResourceLocation lastTexture;
    private int progress = 0;
    private long lastPushed = 0L;
    private boolean needsProgressUpdate = false;
    private boolean needsRecipeUpdate = false;

    public static void tick(Level level, BlockPos pos, BlockState state, LoomBlockEntity loom) {
        if (loom.needsRecipeUpdate) {
            loom.updateCachedRecipe();
            loom.needsRecipeUpdate = false;
        }
        if (!level.f_46443_) {
            loom.checkForLastTickSync();
        }
        if (loom.recipe != null) {
            if (loom.lastTexture == null) {
                loom.lastTexture = loom.recipe.getInProgressTexture();
            }
            LoomRecipe recipe = loom.recipe;
            if (loom.needsProgressUpdate && level.m_46467_() - loom.lastPushed >= 20L) {
                loom.needsProgressUpdate = false;
                ++loom.progress;
                if (loom.progress == recipe.getStepCount()) {
                    ((ItemStackHandler)loom.inventory).setStackInSlot(0, ItemStack.f_41583_);
                    ((ItemStackHandler)loom.inventory).setStackInSlot(1, recipe.assemble(new ItemStackInventory(((ItemStackHandler)loom.inventory).getStackInSlot(0)), level.m_9598_()));
                }
                loom.markForSync();
            }
        }
    }

    public LoomBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.LOOM.get(), pos, state, LoomBlockEntity.defaultInventory(2), NAME);
        if (((Boolean)TFCConfig.SERVER.loomEnableAutomation.get()).booleanValue()) {
            this.sidedInventory.on(new PartialItemHandler(this.inventory).insert(0), (Predicate<Direction>)Direction.Plane.HORIZONTAL);
            this.sidedInventory.on(new PartialItemHandler(this.inventory).extract(1), Direction.DOWN);
        }
    }

    public InteractionResult onRightClick(Player player) {
        assert (this.f_58857_ != null);
        ItemStack heldItem = player.m_21205_();
        if (player.m_6144_()) {
            if (!((ItemStackHandler)this.inventory).getStackInSlot(0).m_41619_()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)((ItemStackHandler)this.inventory).extractItem(0, Integer.MAX_VALUE, false));
                this.clearRecipe();
                this.markForSync();
                return InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
            }
            return InteractionResult.PASS;
        }
        if (!((ItemStackHandler)this.inventory).getStackInSlot(1).m_41619_()) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)((ItemStackHandler)this.inventory).getStackInSlot(1).m_41777_());
            ((ItemStackHandler)this.inventory).setStackInSlot(1, ItemStack.f_41583_);
            this.markForSync();
            this.clearRecipe();
            return InteractionResult.SUCCESS;
        }
        ItemStack recipeItem = ((ItemStackHandler)this.inventory).getStackInSlot(0);
        if (recipeItem.m_41619_() && this.isItemValid(0, heldItem)) {
            ((ItemStackHandler)this.inventory).setStackInSlot(0, heldItem.m_41620_(1));
            this.updateCachedRecipe();
            this.markForSync();
            return InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
        }
        if (!recipeItem.m_41619_() && heldItem.m_41720_() == recipeItem.m_41720_() && this.recipe != null && this.recipe.getInputCount() > recipeItem.m_41613_()) {
            ((ItemStackHandler)this.inventory).getStackInSlot(0).m_41769_(1);
            heldItem.m_41774_(1);
            this.markForSync();
            return InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
        }
        if (this.recipe != null && heldItem.m_41619_() && this.recipe.getInputCount() == ((ItemStackHandler)this.inventory).getStackInSlot(0).m_41613_() && this.progress < this.recipe.getStepCount() && !this.needsProgressUpdate) {
            long time = this.f_58857_.m_46467_() - this.lastPushed;
            if (time <= 20L) {
                return InteractionResult.PASS;
            }
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)TFCSounds.LOOM_WEAVE.get(), SoundSource.BLOCKS, 1.0f, 1.0f + (this.f_58857_.f_46441_.m_188501_() - this.f_58857_.f_46441_.m_188501_()) / 16.0f);
            this.lastPushed = this.f_58857_.m_46467_();
            this.needsProgressUpdate = true;
            this.markForSync();
            return InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean currentBoolean() {
        return this.progress % 2 == 0;
    }

    public int getCount() {
        return ((ItemStackHandler)this.inventory).getStackInSlot(0).m_41613_();
    }

    public int getProgress() {
        return this.progress;
    }

    @Nullable
    public LoomRecipe getRecipe() {
        return this.recipe;
    }

    public double getAnimPos() {
        assert (this.f_58857_ != null);
        if (this.recipe == null) {
            return 0.0;
        }
        int time = (int)(this.f_58857_.m_46467_() - this.lastPushed);
        if (time < 20) {
            return Math.sin(0.15707963267948966 * (double)time) * 0.23125;
        }
        return 0.0;
    }

    private void clearRecipe() {
        this.progress = 0;
        this.recipe = null;
        this.lastTexture = null;
        this.markForSync();
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.needsRecipeUpdate = true;
        this.markForSync();
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        assert (this.f_58857_ != null);
        if (slot == 0) {
            if (!((ItemStackHandler)this.inventory).getStackInSlot(1).m_41619_()) {
                return false;
            }
            return LoomRecipe.getRecipe(this.f_58857_, stack) != null;
        }
        return true;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("progress", this.progress);
        if (this.lastTexture != null) {
            tag.m_128359_("lastTexture", this.lastTexture.toString());
        }
        tag.m_128356_("lastPushed", this.lastPushed);
        super.m_183515_(tag);
    }

    @Override
    public void loadAdditional(CompoundTag tag) {
        this.progress = tag.m_128451_("progress");
        this.lastTexture = tag.m_128425_("lastTexture", 8) ? Helpers.resourceLocation(tag.m_128461_("lastTexture")) : null;
        this.needsRecipeUpdate = true;
        this.lastPushed = tag.m_128454_("lastPushed");
        super.loadAdditional(tag);
    }

    @Override
    public int getSlotStackLimit(int slot) {
        if (slot == 1) {
            return 64;
        }
        return this.recipe != null ? this.recipe.getInputCount() : 1;
    }

    @Nullable
    public ResourceLocation getLastTexture() {
        return this.lastTexture;
    }

    private void updateCachedRecipe() {
        assert (this.f_58857_ != null);
        this.recipe = LoomRecipe.getRecipe(this.f_58857_, ((ItemStackHandler)this.inventory).getStackInSlot(0));
        if (this.recipe == null && this.progress > 0) {
            this.progress = 0;
            this.markForSync();
        }
        if (((ItemStackHandler)this.inventory).getStackInSlot(1).m_41619_()) {
            this.lastTexture = null;
            this.markForSync();
        }
    }
}

