/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.util.Metal;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class IngotPileBlockEntity
extends TFCBlockEntity {
    private final List<Entry> entries = new ArrayList<Entry>();

    public IngotPileBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.INGOT_PILE.get(), pos, state);
    }

    public void addIngot(ItemStack stack) {
        this.entries.add(new Entry(stack));
        this.markForSync();
    }

    public void removeAllIngots(Consumer<ItemStack> ingotConsumer) {
        for (Entry entry : this.entries) {
            ingotConsumer.accept(entry.stack);
        }
        this.entries.clear();
        this.markForSync();
    }

    public ItemStack removeIngot() {
        if (!this.entries.isEmpty()) {
            Entry entry = this.entries.remove(this.entries.size() - 1);
            this.markForSync();
            return entry.stack;
        }
        return ItemStack.f_41583_;
    }

    public Metal getOrCacheMetal(int index) {
        Entry entry;
        if (index >= this.entries.size()) {
            return Metal.unknown();
        }
        try {
            entry = this.entries.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return Metal.unknown();
        }
        if (entry.metal == null) {
            entry.metal = Metal.getFromIngot(entry.stack);
            if (entry.metal == null) {
                entry.metal = Metal.unknown();
            }
        }
        return entry.metal;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        ListTag stacks = new ListTag();
        for (Entry entry : this.entries) {
            stacks.add((Object)entry.stack.m_41739_(new CompoundTag()));
        }
        tag.m_128365_("stacks", (Tag)stacks);
        super.m_183515_(tag);
    }

    @Override
    protected void loadAdditional(CompoundTag tag) {
        this.entries.clear();
        ListTag list = tag.m_128437_("stacks", 10);
        for (int i = 0; i < list.size(); ++i) {
            this.entries.add(new Entry(ItemStack.m_41712_((CompoundTag)list.m_128728_(i))));
        }
        super.loadAdditional(tag);
    }

    public void fillTooltip(Consumer<Component> tooltip) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (Entry entry : this.entries) {
            Metal metal2 = entry.metal;
            if (metal2 == null) continue;
            map.mergeInt((Object)metal2, 1, Integer::sum);
        }
        map.forEach((metal, ct) -> tooltip.accept((Component)Component.m_237113_((String)(ct + "x ")).m_7220_((Component)metal.getDisplayName())));
    }

    public ItemStack getPickedItemStack() {
        return this.entries.isEmpty() ? ItemStack.f_41583_ : this.entries.get((int)0).stack.m_41777_();
    }

    static class Entry {
        final ItemStack stack;
        @Nullable
        Metal metal;

        Entry(ItemStack stack) {
            this.stack = stack;
        }
    }
}

